/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.raft;

import com.alipay.remoting.serialization.SerializerManager;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.DBCommandChunk;
import top.thinkin.lightd.base.DBCommandChunkType;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.raft.DBClosure;
import top.thinkin.lightd.raft.DBRequestProcessor;
import top.thinkin.lightd.raft.Util;

public class DBStateMachine
extends StateMachineAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DBStateMachine.class);
    private volatile DB db;
    private static String spname = "sp";
    private DBRequestProcessor dbRequestProcessor;
    private String dbName;
    private ConcurrentHashMap<String, List<DBCommandChunk>> logbatchs = new ConcurrentHashMap();
    private final AtomicLong leaderTerm = new AtomicLong(-1L);

    public DB getDb() {
        return this.db;
    }

    public void setDbRequestProcessor(DBRequestProcessor dbRequestProcessor) {
        this.dbRequestProcessor = dbRequestProcessor;
    }

    public DBRequestProcessor getDbRequestProcessor() {
        return this.dbRequestProcessor;
    }

    public void setDB(DB db) {
        this.db = db;
        db.functionCommit = logs -> this.dbRequestProcessor.call(logs);
    }

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public void onError(RaftException e) {
        LOG.error("onSnapshotLoad error", (Throwable)e);
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        try {
            String fileName = this.db.backupDB(writer.getPath(), spname);
            if (writer.addFile(spname + DB.BACK_FILE_SUFFIX)) {
                done.run(Status.OK());
            } else {
                done.run(new Status(RaftError.EIO, "Fail to add file to writer", new Object[0]));
            }
        }
        catch (Exception e) {
            done.run(new Status(RaftError.EIO, "Fail to save counter snapshot %s", new Object[]{writer.getPath()}));
        }
    }

    public void onLeaderStart(long term) {
        super.onLeaderStart(term);
        this.leaderTerm.set(term);
    }

    public void onLeaderStop(Status status) {
        super.onLeaderStop(status);
        this.leaderTerm.set(-1L);
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        LOG.info("===========onSnapshotLoad start==============");
        if (this.isLeader()) {
            LOG.warn("Leader is not supposed to load snapshot.");
            return false;
        }
        String path = reader.getPath();
        if (this.db != null) {
            try {
                this.db.stop();
            }
            catch (Exception e) {
                LOG.error("onSnapshotLoad error", (Throwable)e);
                return false;
            }
        }
        Util.delZSPic(this.db.getDir());
        try {
            DB.releaseBackup((String)(path + File.separator + spname + DB.BACK_FILE_SUFFIX), (String)this.db.getDir());
            this.db.open(false, false);
            return true;
        }
        catch (Exception e) {
            LOG.error("onSnapshotLoad error", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApply(Iterator iter) {
        while (iter.hasNext()) {
            ByteBuffer data = iter.getData();
            DBClosure closure = null;
            boolean isLeader = false;
            try {
                DBCommandChunk chunk = null;
                if (iter.done() != null) {
                    closure = (DBClosure)iter.done();
                    chunk = closure.getChunk();
                    isLeader = true;
                } else {
                    try {
                        DBCommandChunk request;
                        chunk = request = (DBCommandChunk)SerializerManager.getSerializer((int)1).deserialize(data.array(), DBCommandChunk.class.getName());
                    }
                    catch (Exception e) {
                        LOG.error("Get Serialize ERROR", (Throwable)e);
                    }
                }
                try {
                    DBCommandChunkType dbCommandChunkType = chunk.getType();
                    if (chunk.getCommands() != null) {
                        LOG.debug("onApply {} {}", (Object)dbCommandChunkType.name(), (Object)chunk.getCommands().size());
                    } else {
                        LOG.debug("onApply {} {}", (Object)dbCommandChunkType.name());
                    }
                    if (!isLeader) {
                        switch (dbCommandChunkType) {
                            case NOM_COMMIT: {
                                this.db.simpleCommit(chunk.getCommands());
                                break;
                            }
                            case TX_LOGS: {
                                List<DBCommandChunk> logbatch_logs = this.logbatchs.get(chunk.getEntity().getUuid());
                                if (logbatch_logs == null) {
                                    logbatch_logs = new ArrayList<DBCommandChunk>();
                                    this.logbatchs.put(chunk.getEntity().getUuid(), logbatch_logs);
                                }
                                logbatch_logs.add(chunk);
                                break;
                            }
                            case TX_COMMIT: {
                                List<DBCommandChunk> logbatch_commit = this.logbatchs.get(chunk.getEntity().getUuid());
                                if (logbatch_commit != null) {
                                    for (DBCommandChunk dbCommandChunk : logbatch_commit) {
                                        this.db.simpleCommit(dbCommandChunk.getCommands());
                                    }
                                }
                                this.logbatchs.remove(chunk.getEntity().getUuid());
                                break;
                            }
                            case TX_ROLLBACK: {
                                this.logbatchs.remove(chunk.getEntity().getUuid());
                                break;
                            }
                            case SIMPLE_COMMIT: {
                                this.db.simpleCommit(chunk.getCommands());
                            }
                        }
                    } else {
                        switch (dbCommandChunkType) {
                            case NOM_COMMIT: {
                                this.db.simpleCommit(chunk.getCommands());
                                break;
                            }
                            case TX_LOGS: {
                                this.db.commit(chunk.getCommands(), chunk.getEntity());
                                break;
                            }
                            case TX_COMMIT: {
                                this.db.commitTX(chunk.getEntity());
                                break;
                            }
                            case TX_ROLLBACK: {
                                this.db.rollbackTX(chunk.getEntity());
                                break;
                            }
                            case SIMPLE_COMMIT: {
                                this.db.simpleCommit(chunk.getCommands());
                                break;
                            }
                            default: {
                                throw new KitDBException(ErrorType.NULL, "DBCommandChunkType non-existent!");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("STORE ERROR", (Throwable)e);
                    closure.run(new Status(-1, e.getMessage()));
                    if (closure != null) {
                        DBClosure dBClosure = closure;
                        synchronized (dBClosure) {
                            closure.notifyAll();
                        }
                    }
                    return;
                }
                if (closure != null) {
                    closure.run(Status.OK());
                }
            }
            finally {
                if (closure != null) {
                    DBClosure dBClosure = closure;
                    synchronized (dBClosure) {
                        closure.notifyAll();
                    }
                }
            }
            iter.next();
        }
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

