/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.raft;

import com.alipay.remoting.rpc.RpcServer;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.raft.DBRequestProcessor;
import top.thinkin.lightd.raft.DBStateMachine;
import top.thinkin.lightd.raft.GroupConfig;
import top.thinkin.lightd.raft.NodeConfig;

public class KitRaft {
    private static final Logger LOG = LoggerFactory.getLogger(KitRaft.class);
    private RaftGroupService raftGroupService;
    private Node node;
    private DBStateMachine dbsm;

    public DB getDB() {
        return this.dbsm.getDb();
    }

    public KitRaft() {
    }

    public KitRaft(GroupConfig groupConfig, NodeConfig nodeConfig, DB db) throws IOException {
        NodeOptions nodeOptions = new NodeOptions();
        RaftOptions raftOptions = new RaftOptions();
        raftOptions.setDisruptorBufferSize(262144);
        raftOptions.setApplyBatch(128);
        raftOptions.setSync(false);
        nodeOptions.setRaftOptions(raftOptions);
        nodeOptions.setElectionTimeoutMs(groupConfig.getElectionTimeoutMs());
        nodeOptions.setDisableCli(true);
        nodeOptions.setSnapshotIntervalSecs(groupConfig.getSnapshotIntervalSecs());
        PeerId serverId = new PeerId();
        if (!serverId.parse(nodeConfig.getNode())) {
            throw new IllegalArgumentException("Fail to parse serverId:" + nodeConfig.getNode());
        }
        Configuration initConf = new Configuration();
        if (!initConf.parse(groupConfig.getInitNodes())) {
            throw new IllegalArgumentException("Fail to parse initConf:" + groupConfig.getInitNodes());
        }
        nodeOptions.setInitialConf(initConf);
        String raftDir = nodeConfig.getRaftDir();
        FileUtils.forceMkdir((File)new File(raftDir));
        RpcServer rpcServer = new RpcServer(serverId.getPort());
        RaftRpcServerFactory.addRaftRequestProcessors((RpcServer)rpcServer);
        this.dbsm = new DBStateMachine();
        this.dbsm.setDbRequestProcessor(new DBRequestProcessor(this));
        this.dbsm.setDB(db);
        nodeOptions.setFsm((StateMachine)this.dbsm);
        nodeOptions.setLogUri(raftDir + File.separator + "log");
        nodeOptions.setRaftMetaUri(raftDir + File.separator + "raft_meta");
        nodeOptions.setSnapshotUri(raftDir + File.separator + "snapshot");
        this.raftGroupService = new RaftGroupService(groupConfig.getGroup(), serverId, nodeOptions, rpcServer);
        this.node = this.raftGroupService.start();
    }

    public void addNode(String nodeConf) {
        PeerId peer = new PeerId();
        peer.parse(nodeConf);
        this.node.addPeer(peer, s -> LOG.error("addNode error", (Object)s.getErrorMsg()));
    }

    public void removeNode(String nodeConf) {
        PeerId peer = new PeerId();
        peer.parse(nodeConf);
        this.node.removePeer(peer, s -> LOG.error("removeNode error", (Object)s.getErrorMsg()));
    }

    public void transferLeader(String nodeConf) {
        PeerId serverId = new PeerId();
        if (!serverId.parse(nodeConf)) {
            throw new IllegalArgumentException("Fail to parse Conf:" + nodeConf);
        }
        this.node.transferLeadershipTo(serverId);
    }

    public String getLeader() {
        PeerId peerId = this.node.getLeaderId();
        if (peerId == null) {
            return null;
        }
        return this.node.getLeaderId().toString();
    }

    public String getLeaderIP() {
        PeerId peerId = this.node.getLeaderId();
        if (peerId == null) {
            return null;
        }
        return this.node.getLeaderId().getIp();
    }

    public boolean isLeader() {
        return this.dbsm.isLeader();
    }

    public List<String> getNodes() {
        ArrayList<String> nodes = new ArrayList<String>();
        List peerIds = this.node.listPeers();
        for (PeerId peerId : peerIds) {
            nodes.add(peerId.toString());
        }
        return nodes;
    }

    public List<String> getAliveNodes() {
        ArrayList<String> nodes = new ArrayList<String>();
        List peerIds = this.node.listAlivePeers();
        for (PeerId peerId : peerIds) {
            nodes.add(peerId.toString());
        }
        return nodes;
    }

    public DBStateMachine getFsm() {
        return this.dbsm;
    }

    protected Node getNode() {
        return this.node;
    }

    protected RaftGroupService RaftGroupService() {
        return this.raftGroupService;
    }
}

