/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.io.Serializable;
import java.util.Arrays;
import top.thinkin.lightd.base.DBCommandType;
import top.thinkin.lightd.base.SstColumnFamily;

public class DBCommand
implements Serializable {
    private static final long serialVersionUID = -1L;
    private DBCommandType type;
    private SstColumnFamily family;
    private byte[] key;
    private byte[] value;
    private byte[] start;
    private byte[] end;

    public static DBCommand update(byte[] key, byte[] value, SstColumnFamily family) {
        DBCommand dbCommand = new DBCommand();
        dbCommand.key = key;
        dbCommand.value = value;
        dbCommand.type = DBCommandType.UPDATE;
        dbCommand.family = family;
        return dbCommand;
    }

    public static DBCommand update(byte[] key, byte[] value) {
        return DBCommand.update(key, value, SstColumnFamily.DEFAULT);
    }

    public static DBCommand delete(byte[] key, SstColumnFamily family) {
        DBCommand dbCommand = new DBCommand();
        dbCommand.key = key;
        dbCommand.type = DBCommandType.DELETE;
        dbCommand.family = family;
        return dbCommand;
    }

    public static DBCommand delete(byte[] key) {
        return DBCommand.delete(key, SstColumnFamily.DEFAULT);
    }

    public static DBCommand deleteRange(byte[] start, byte[] end, SstColumnFamily family) {
        DBCommand dbCommand = new DBCommand();
        dbCommand.start = start;
        dbCommand.end = end;
        dbCommand.type = DBCommandType.DELETE_RANGE;
        dbCommand.family = family;
        return dbCommand;
    }

    public static DBCommand deleteRange(byte[] start, byte[] end) {
        return DBCommand.deleteRange(start, end, SstColumnFamily.DEFAULT);
    }

    public void readLogs() {
    }

    public DBCommandType getType() {
        return this.type;
    }

    public SstColumnFamily getFamily() {
        return this.family;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getStart() {
        return this.start;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public void setType(DBCommandType type) {
        this.type = type;
    }

    public void setFamily(SstColumnFamily family) {
        this.family = family;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setStart(byte[] start) {
        this.start = start;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBCommand)) {
            return false;
        }
        DBCommand other = (DBCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DBCommandType this$type = this.getType();
        DBCommandType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        SstColumnFamily this$family = this.getFamily();
        SstColumnFamily other$family = other.getFamily();
        if (this$family == null ? other$family != null : !((Object)((Object)this$family)).equals((Object)other$family)) {
            return false;
        }
        if (!Arrays.equals(this.getKey(), other.getKey())) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        if (!Arrays.equals(this.getStart(), other.getStart())) {
            return false;
        }
        return Arrays.equals(this.getEnd(), other.getEnd());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DBCommandType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        SstColumnFamily $family = this.getFamily();
        result = result * 59 + ($family == null ? 43 : ((Object)((Object)$family)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKey());
        result = result * 59 + Arrays.hashCode(this.getValue());
        result = result * 59 + Arrays.hashCode(this.getStart());
        result = result * 59 + Arrays.hashCode(this.getEnd());
        return result;
    }

    public String toString() {
        return "DBCommand(type=" + (Object)((Object)this.getType()) + ", family=" + (Object)((Object)this.getFamily()) + ", key=" + Arrays.toString(this.getKey()) + ", value=" + Arrays.toString(this.getValue()) + ", start=" + Arrays.toString(this.getStart()) + ", end=" + Arrays.toString(this.getEnd()) + ")";
    }
}

