/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.KeyLock;
import top.thinkin.lightd.base.LockEntity;

public class SegmentStrLock
implements KeyLock {
    private static final Logger log = LoggerFactory.getLogger(SegmentStrLock.class);
    private final CopyOnWriteArrayList<ReentrantLock> buckets = new CopyOnWriteArrayList();
    private final int size;

    public SegmentStrLock(int size) {
        this.size = size;
        for (int i = 0; i < this.size; ++i) {
            this.buckets.add(new ReentrantLock(true));
        }
    }

    @Override
    public LockEntity lock(String key) {
        int h = this.hash(key.hashCode());
        ReentrantLock lock = this.buckets.get(h);
        lock.lock();
        LockEntity lockEntity = new LockEntity(key, this);
        return lockEntity;
    }

    @Override
    public void unlock(LockEntity reentrantLock) {
        String key = reentrantLock.getKey();
        int h = this.hash(key.hashCode());
        ReentrantLock lock = this.buckets.get(h);
        lock.unlock();
    }

    private int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return this.size - 1 & n;
    }
}

