/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.MetaAbs;
import top.thinkin.lightd.base.MetaDAbs;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.KeyIterator;
import top.thinkin.lightd.db.RCollection;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.db.RIterator;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class ZSet
extends RCollection {
    private static final Logger log = LoggerFactory.getLogger(ZSet.class);
    public static String HEAD = KeyEnum.ZSET.getKey();
    public static byte[] HEAD_B = HEAD.getBytes();
    public static byte[] HEAD_SCORE_B = KeyEnum.ZSET_S.getBytes();
    public static byte[] HEAD_V_B = KeyEnum.ZSET_V.getBytes();

    @Override
    protected TxLock getTxLock(String key) {
        return new TxLock(String.join((CharSequence)":", HEAD, key));
    }

    protected ZSet(DB db) {
        super(db, false, 128);
    }

    protected byte[] getKey(String key) throws KitDBException {
        DAssert.notNull(key, ErrorType.NULL, "Key is null");
        return ArrayKits.addAll(HEAD_B, key.getBytes(charset));
    }

    public void add(String key, byte[] v, long score) throws KitDBException {
        this.addMayTTL(key, -1, new Entry(score, v));
    }

    public void add(String key, List<Entry> entryList) throws KitDBException {
        Entry[] entries = new Entry[entryList.size()];
        entryList.toArray(entries);
        this.addMayTTL(key, -1, entries);
    }

    public void addMayTTL(String key, int ttl, byte[] v, long score) throws KitDBException {
        this.addMayTTL(key, ttl, new Entry(score, v));
    }

    private void addMayTTL(String key, int ttl, List<Entry> entryList) throws KitDBException {
        Entry[] entries = new Entry[entryList.size()];
        entryList.toArray(entries);
        this.addMayTTL(key, ttl, entries);
    }

    public boolean contains(String key, byte[] value) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                boolean bl = false;
                return bl;
            }
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), value);
            boolean bl = this.getDB(sData.convertBytes().toBytes(), SstColumnFamily.DEFAULT) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMayTTL(String key, int ttl, Entry ... entrys) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            DAssert.notEmpty(entrys, ErrorType.EMPTY, "entrys is empty");
            LockEntity lockEntity = this.lock(key);
            byte[] key_b = this.getKey(key);
            byte[][] bytess = new byte[entrys.length][];
            for (int i = 0; i < entrys.length; ++i) {
                bytess[i] = entrys[i].value;
            }
            DAssert.isTrue(ArrayKits.noRepeate(bytess), ErrorType.REPEATED_KEY, "Repeated memebers");
            try {
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                MetaV metaV = this.addCheck(key_b, k_v);
                if (metaV != null) {
                    this.setEntry(key_b, metaV, entrys);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    if (ttl != -1) {
                        ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                    }
                    metaV = new MetaV(0, ttl, this.db.versionSequence().incr());
                    this.setEntry(key_b, metaV, entrys);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                    if (metaV.getTimestamp() != -1) {
                        this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    private void setEntry(byte[] key_b, MetaV metaV, Entry[] entrys) throws KitDBException {
        for (Entry entry : entrys) {
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), entry.value);
            ZData zData = new ZData(key_b.length, key_b, metaV.getVersion(), entry.score, entry.value);
            byte[] member = sData.convertBytes().toBytes();
            byte[] old_score_bs = this.getDB(member, SstColumnFamily.DEFAULT);
            if (old_score_bs == null) {
                metaV.size = metaV.size + 1;
            } else {
                ZData zData_old = new ZData(key_b.length, key_b, metaV.getVersion(), ArrayKits.bytesToLong(old_score_bs), entry.value);
                this.deleteDB(zData_old.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
            }
            this.putDB(member, ArrayKits.longToBytes(entry.score), SstColumnFamily.DEFAULT);
            this.putDB(zData.convertBytes().toBytes(), "".getBytes(), SstColumnFamily.DEFAULT);
        }
    }

    public List<Entry> range(String key, long start, long end, int limit) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            MetaV metaV = this.getMeta(key_b);
            ZData zData = new ZData(key_b.length, key_b, metaV.getVersion(), start, "".getBytes());
            byte[] seek = zData.getSeek();
            byte[] head = zData.getHead();
            try (RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);){
                iterator.seek(seek);
                long index = 0L;
                for (int count = 0; iterator.isValid() && index <= end && count < limit; ++count) {
                    byte[] key_bs = iterator.key();
                    if (!BytesUtil.checkHead(head, key_bs)) {
                        break;
                    }
                    ZData izData = ZDataD.build(key_bs).convertValue();
                    index = izData.getScore();
                    if (index > end) {
                        break;
                    }
                    entries.add(new Entry(index, izData.value));
                    iterator.next();
                }
            }
            ArrayList<Entry> arrayList = entries;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Entry> rangeDel(String key, long start, long end, int limit) throws KitDBException {
        this.checkTxStart();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        byte[] key_b = this.getKey(key);
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            try (RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);){
                ZDataD zDataD;
                ZData izData;
                byte[] key_bs;
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    ArrayList<Entry> arrayList = entries;
                    return arrayList;
                }
                ZData zData = new ZData(key_b.length, key_b, metaV.getVersion(), start, "".getBytes());
                byte[] seek = zData.getSeek();
                byte[] head = zData.getHead();
                ArrayList<byte[]> dels = new ArrayList<byte[]>();
                iterator.seek(seek);
                long index = 0L;
                for (int count = 0; iterator.isValid() && index <= end && count < limit && BytesUtil.checkHead(head, key_bs = iterator.key()) && (index = (izData = (zDataD = ZDataD.build(key_bs)).convertValue()).getScore()) <= end; ++count) {
                    entries.add(new Entry(index, izData.value));
                    metaV.setSize(metaV.getSize() - 1);
                    dels.add(zDataD.toBytes());
                    SDataD sDataD = new SDataD(zDataD.getMapKeySize(), key_b, zDataD.getVersion(), zDataD.getValue());
                    dels.add(sDataD.toBytes());
                    iterator.next();
                }
                this.start();
                this.removeDo(key_b, metaV, dels);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
            return entries;
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public RIterator<ZSet> iterator(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            RIterator<ZSet> rIterator;
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), "".getBytes());
            RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);
            iterator.seek(sData.getHead());
            RIterator<ZSet> rIterator2 = rIterator = new RIterator<ZSet>(iterator, this, sData.getHead());
            return rIterator2;
        }
    }

    private void removeDo(byte[] key_b, MetaV metaV, List<byte[]> dels) {
        for (byte[] del : dels) {
            this.deleteDB(del, SstColumnFamily.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrby(String key, int increment, byte[] ... vs) throws KitDBException {
        DAssert.notEmpty((Object[])vs, ErrorType.EMPTY, "vs is empty");
        this.checkTxStart();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            try {
                this.start();
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                for (byte[] v : vs) {
                    SData sData = new SData(key_b.length, key_b, metaV.getVersion(), v);
                    SDataD sDataD = sData.convertBytes();
                    byte[] scoreD = this.getDB(sDataD.toBytes(), SstColumnFamily.DEFAULT);
                    if (scoreD == null) continue;
                    int score = ArrayKits.bytesToInt(scoreD, 0) + increment;
                    scoreD = ArrayKits.intToBytes(score);
                    ZDataD zDataD = new ZDataD(sDataD.getMapKeySize(), sDataD.getMapKey(), sDataD.getVersion(), scoreD, sDataD.getValue());
                    this.putDB(sData.convertBytes().toBytes(), scoreD, SstColumnFamily.DEFAULT);
                    this.putDB(zDataD.toBytes(), null, SstColumnFamily.DEFAULT);
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, byte[] ... vs) throws KitDBException {
        DAssert.notEmpty((Object[])vs, ErrorType.EMPTY, "vs is empty");
        this.checkTxStart();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            this.start();
            try {
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                ArrayList<byte[]> dels = new ArrayList<byte[]>();
                for (byte[] v : vs) {
                    SData sData = new SData(key_b.length, key_b, metaV.getVersion(), v);
                    SDataD sDataD = sData.convertBytes();
                    byte[] scoreD = this.getDB(sDataD.toBytes(), SstColumnFamily.DEFAULT);
                    if (scoreD == null) continue;
                    ZDataD zDataD = new ZDataD(sDataD.getMapKeySize(), sDataD.getMapKey(), sDataD.getVersion(), scoreD, sDataD.getValue());
                    dels.add(zDataD.toBytes());
                    dels.add(sDataD.toBytes());
                    metaV.setSize(metaV.getSize() - 1);
                }
                this.removeDo(key_b, metaV, dels);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public List<Long> score(String key, byte[] ... vs) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            DAssert.notEmpty((Object[])vs, ErrorType.EMPTY, "vs is empty");
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            ArrayList<Long> scores = new ArrayList<Long>();
            for (byte[] v : vs) {
                SData sData = new SData(key_b.length, key_b, metaV.getVersion(), v);
                byte[] scoreD = this.getDB(sData.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
                if (scoreD != null) {
                    scores.add(ArrayKits.bytesToLong(scoreD));
                }
                scores.add(null);
            }
            ArrayList<Long> arrayList = scores;
            return arrayList;
        }
    }

    public Long score(String key, byte[] v) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                Long l = null;
                return l;
            }
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), v);
            byte[] scoreD = this.getDB(sData.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
            if (scoreD != null) {
                Long l = ArrayKits.bytesToLong(scoreD);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    private MetaV addCheck(byte[] key_b, byte[] k_v) {
        MetaV metaV = null;
        if (k_v != null) {
            MetaD metaD = MetaD.build(k_v);
            metaV = metaD.convertMetaV();
            long nowTime = System.currentTimeMillis() / 1000L;
            if (metaV.getTimestamp() != -1 && nowTime > (long)metaV.getTimestamp()) {
                metaV = null;
            }
        }
        return metaV;
    }

    private MetaV getMetaP(byte[] key_b) throws KitDBException {
        byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
        if (k_v == null) {
            return null;
        }
        MetaV metaV = MetaD.build(k_v).convertMetaV();
        return metaV;
    }

    protected MetaV getMeta(byte[] key_b) throws KitDBException {
        MetaV metaV = this.getMetaP(key_b);
        if (metaV == null) {
            return null;
        }
        if (metaV.getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteByClear(byte[] key_b, MetaD meta) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            this.start();
            this.delete(key_b, meta);
            this.commitLocal();
        }
        finally {
            this.release();
        }
    }

    private void delete(byte[] key_b, MetaD metaD) {
        MetaV metaV = metaD.convertMetaV();
        SData sData = new SData(key_b.length, key_b, metaV.getVersion(), null);
        this.deleteHead(sData.getHead(), SstColumnFamily.DEFAULT);
        ZData zData = new ZData(sData.getMapKeySize(), sData.getMapKey(), sData.getVersion(), 0L, null);
        this.deleteHead(zData.getHead(), SstColumnFamily.DEFAULT);
        this.deleteDB(ArrayKits.addAll("D".getBytes(charset), key_b, metaD.getVersion()), SstColumnFamily.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) throws KitDBException {
        this.checkTxRange();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                this.start();
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.deleteDB(key_b, SstColumnFamily.META);
                this.delete(key_b, metaV.convertMetaBytes());
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public KeyIterator getKeyIterator() throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            KeyIterator keyIterator = this.getKeyIterator(HEAD_B);
            return keyIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFast(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                if (k_v == null) {
                    this.checkTxCommit();
                    return;
                }
                MetaV meta = MetaD.build(k_v).convertMetaV();
                this.deleteFast(key_b, meta);
            }
            finally {
                this.unlock(lockEntity);
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public int getTtl(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                int n = -1;
                return n;
            }
            if (metaV.getTimestamp() == -1) {
                int n = -1;
                return n;
            }
            int n = (int)((long)metaV.getTimestamp() - System.currentTimeMillis() / 1000L);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delTtl(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            byte[] key_b = this.getKey(key);
            try {
                MetaV metaV = this.getMetaP(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp(-1);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTTL(int time, byte[] key_b, byte[] meta_b) throws KitDBException {
        String key = new String(ArrayKits.sub(key_b, 1, key_b.length + 1), charset);
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            MetaV metaV = this.getMetaP(key_b);
            if (metaV != null && time != metaV.timestamp) {
                return;
            }
            this.deleteTTL(key_b, MetaD.build(meta_b).convertMetaV(), metaV.version);
        }
        finally {
            this.unlock(lockEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ttl(String key, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            byte[] key_b = this.getKey(key);
            try {
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp((int)(System.currentTimeMillis() / 1000L + (long)ttl));
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public boolean isExist(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
            MetaV meta = this.addCheck(key_b, k_v);
            boolean bl = meta != null;
            return bl;
        }
    }

    @Override
    public int size(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            int size = 0;
            try (RIterator<ZSet> iterator = this.iterator(key);){
                while (iterator.hasNext()) {
                    iterator.next();
                    ++size;
                }
            }
            int n = size;
            return n;
        }
    }

    public Entry getEntry(RocksIterator iterator) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            Entry entry;
            byte[] key_bs = iterator.key();
            if (key_bs == null) {
                Entry entry2 = null;
                return entry2;
            }
            SData sData = SDataD.build(key_bs).convertValue();
            Entry entry3 = entry = new Entry(ArrayKits.bytesToLong(iterator.value()), sData.value);
            return entry3;
        }
    }

    public static class ZDataD {
        private byte[] mapKeySize;
        private byte[] mapKey;
        private byte[] version;
        private byte[] score;
        private byte[] value;

        public byte[] toBytes() {
            return ArrayKits.addAll(HEAD_SCORE_B, this.mapKeySize, this.mapKey, this.version, this.score, this.value);
        }

        public static ZDataD build(byte[] bytes) {
            ZDataD zData = new ZDataD();
            zData.setMapKeySize(ArrayKits.sub(bytes, 1, 5));
            int position = ArrayKits.bytesToInt(zData.getMapKeySize(), 0);
            position = 5 + position;
            zData.setMapKey(ArrayKits.sub(bytes, 5, position));
            zData.setVersion(ArrayKits.sub(bytes, position, position += 4));
            zData.setScore(ArrayKits.sub(bytes, position, position += 8));
            zData.setValue(ArrayKits.sub(bytes, position, bytes.length));
            return zData;
        }

        public ZData convertValue() {
            ZData zData = new ZData();
            zData.setMapKeySize(ArrayKits.bytesToInt(this.mapKeySize, 0));
            zData.setMapKey(this.mapKey);
            zData.setVersion(ArrayKits.bytesToInt(this.version, 0));
            zData.setScore(ArrayKits.bytesToLong(this.score));
            zData.setValue(this.value);
            return zData;
        }

        public byte[] getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getScore() {
            return this.score;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(byte[] mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setScore(byte[] score) {
            this.score = score;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZDataD)) {
                return false;
            }
            ZDataD other = (ZDataD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getMapKeySize(), other.getMapKeySize())) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            if (!Arrays.equals(this.getScore(), other.getScore())) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZDataD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getMapKeySize());
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getScore());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "ZSet.ZDataD(mapKeySize=" + Arrays.toString(this.getMapKeySize()) + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + Arrays.toString(this.getVersion()) + ", score=" + Arrays.toString(this.getScore()) + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public ZDataD(byte[] mapKeySize, byte[] mapKey, byte[] version, byte[] score, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.score = score;
            this.value = value;
        }

        public ZDataD() {
        }
    }

    public static class ZData {
        private int mapKeySize;
        private byte[] mapKey;
        private int version;
        private long score;
        private byte[] value;

        public ZDataD convertBytes() {
            ZDataD zDataD = new ZDataD();
            zDataD.setMapKeySize(ArrayKits.intToBytes(this.mapKeySize));
            zDataD.setMapKey(this.mapKey);
            zDataD.setVersion(ArrayKits.intToBytes(this.version));
            zDataD.setScore(ArrayKits.longToBytes(this.score));
            zDataD.setValue(this.value);
            return zDataD;
        }

        public byte[] getSeek() {
            byte[] value = ArrayKits.addAll(HEAD_SCORE_B, ArrayKits.intToBytes(this.mapKeySize), this.mapKey, ArrayKits.intToBytes(this.version), ArrayKits.longToBytes(this.score));
            return value;
        }

        public byte[] getHead() {
            byte[] value = ArrayKits.addAll(HEAD_SCORE_B, ArrayKits.intToBytes(this.mapKeySize), this.mapKey, ArrayKits.intToBytes(this.version));
            return value;
        }

        public int getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public int getVersion() {
            return this.version;
        }

        public long getScore() {
            return this.score;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(int mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setScore(long score) {
            this.score = score;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZData)) {
                return false;
            }
            ZData other = (ZData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMapKeySize() != other.getMapKeySize()) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getScore() != other.getScore()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMapKeySize();
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + this.getVersion();
            long $score = this.getScore();
            result = result * 59 + (int)($score >>> 32 ^ $score);
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "ZSet.ZData(mapKeySize=" + this.getMapKeySize() + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + this.getVersion() + ", score=" + this.getScore() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public ZData(int mapKeySize, byte[] mapKey, int version, long score, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.score = score;
            this.value = value;
        }

        public ZData() {
        }
    }

    public static class SDataD {
        private byte[] mapKeySize;
        private byte[] mapKey;
        private byte[] version;
        private byte[] value;

        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_V_B, this.mapKeySize, this.mapKey, this.version, this.value);
            return value;
        }

        public static SDataD build(byte[] bytes) {
            SDataD sDataD = new SDataD();
            sDataD.setMapKeySize(ArrayKits.sub(bytes, 1, 5));
            int position = ArrayKits.bytesToInt(sDataD.getMapKeySize(), 0);
            position = 5 + position;
            sDataD.setMapKey(ArrayKits.sub(bytes, 5, position));
            sDataD.setVersion(ArrayKits.sub(bytes, position, position += 4));
            sDataD.setValue(ArrayKits.sub(bytes, position, bytes.length));
            return sDataD;
        }

        public SData convertValue() {
            SData sData = new SData();
            sData.setMapKeySize(ArrayKits.bytesToInt(this.mapKeySize, 0));
            sData.setMapKey(this.mapKey);
            sData.setVersion(ArrayKits.bytesToInt(this.version, 0));
            sData.setValue(this.value);
            return sData;
        }

        public byte[] getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(byte[] mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SDataD)) {
                return false;
            }
            SDataD other = (SDataD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getMapKeySize(), other.getMapKeySize())) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SDataD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getMapKeySize());
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "ZSet.SDataD(mapKeySize=" + Arrays.toString(this.getMapKeySize()) + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + Arrays.toString(this.getVersion()) + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public SDataD(byte[] mapKeySize, byte[] mapKey, byte[] version, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.value = value;
        }

        public SDataD() {
        }
    }

    public static class SData {
        private int mapKeySize;
        private byte[] mapKey;
        private int version;
        private byte[] value;

        public SDataD convertBytes() {
            SDataD sDataD = new SDataD();
            sDataD.setMapKeySize(ArrayKits.intToBytes(this.mapKeySize));
            sDataD.setMapKey(this.mapKey);
            sDataD.setVersion(ArrayKits.intToBytes(this.version));
            sDataD.setValue(this.value);
            return sDataD;
        }

        public byte[] getHead() {
            byte[] value = ArrayKits.addAll(HEAD_V_B, ArrayKits.intToBytes(this.mapKeySize), this.mapKey, ArrayKits.intToBytes(this.version));
            return value;
        }

        public int getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(int mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SData)) {
                return false;
            }
            SData other = (SData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMapKeySize() != other.getMapKeySize()) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMapKeySize();
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + this.getVersion();
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "ZSet.SData(mapKeySize=" + this.getMapKeySize() + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + this.getVersion() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public SData(int mapKeySize, byte[] mapKey, int version, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.value = value;
        }

        public SData() {
        }
    }

    public static class MetaD
    extends MetaDAbs {
        private byte[] size;
        private byte[] timestamp;
        private byte[] version;

        public static MetaD build(byte[] bytes) {
            MetaD metaD = new MetaD();
            metaD.setSize(ArrayKits.sub(bytes, 1, 5));
            metaD.setTimestamp(ArrayKits.sub(bytes, 5, 9));
            metaD.setVersion(ArrayKits.sub(bytes, 9, 13));
            return metaD;
        }

        public byte[] toBytesHead() {
            byte[] value = ArrayKits.addAll(HEAD_B, ArrayKits.intToBytes(0), ArrayKits.intToBytes(0), this.version);
            return value;
        }

        @Override
        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_B, this.size, this.timestamp, this.version);
            return value;
        }

        public MetaV convertMetaV() {
            MetaV metaV = new MetaV();
            metaV.setSize(ArrayKits.bytesToInt(this.size, 0));
            metaV.setTimestamp(ArrayKits.bytesToInt(this.timestamp, 0));
            metaV.setVersion(ArrayKits.bytesToInt(this.version, 0));
            return metaV;
        }

        public byte[] getSize() {
            return this.size;
        }

        public byte[] getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] getVersion() {
            return this.version;
        }

        public void setSize(byte[] size) {
            this.size = size;
        }

        public void setTimestamp(byte[] timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaD)) {
                return false;
            }
            MetaD other = (MetaD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getSize(), other.getSize())) {
                return false;
            }
            if (!Arrays.equals(this.getTimestamp(), other.getTimestamp())) {
                return false;
            }
            return Arrays.equals(this.getVersion(), other.getVersion());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getSize());
            result = result * 59 + Arrays.hashCode(this.getTimestamp());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            return result;
        }

        public String toString() {
            return "ZSet.MetaD(size=" + Arrays.toString(this.getSize()) + ", timestamp=" + Arrays.toString(this.getTimestamp()) + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }

        public MetaD(byte[] size, byte[] timestamp, byte[] version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaD() {
        }
    }

    public static class MetaV
    extends MetaAbs {
        private int size;
        private int timestamp;
        private int version;

        public MetaD convertMetaBytes() {
            MetaD metaVD = new MetaD();
            metaVD.setSize(ArrayKits.intToBytes(this.size));
            metaVD.setTimestamp(ArrayKits.intToBytes(this.timestamp));
            metaVD.setVersion(ArrayKits.intToBytes(this.version));
            return metaVD;
        }

        public int getSize() {
            return this.size;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaV)) {
                return false;
            }
            MetaV other = (MetaV)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            return this.getVersion() == other.getVersion();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaV;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + this.getTimestamp();
            result = result * 59 + this.getVersion();
            return result;
        }

        public String toString() {
            return "ZSet.MetaV(size=" + this.getSize() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ")";
        }

        public MetaV(int size, int timestamp, int version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaV() {
        }
    }

    public static class Entry
    extends REntry {
        private long score;
        private byte[] value;

        public long getScore() {
            return this.score;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setScore(long score) {
            this.score = score;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScore() != other.getScore()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $score = this.getScore();
            result = result * 59 + (int)($score >>> 32 ^ $score);
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "ZSet.Entry(score=" + this.getScore() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(long score, byte[] value) {
            this.score = score;
            this.value = value;
        }
    }
}

