/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.kit;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import top.thinkin.lightd.kit.BytesUtil;

public class ArrayKits {
    public static byte[] newArray(Class<?> componentType, int newSize) {
        return (byte[])Array.newInstance(componentType, newSize);
    }

    public static byte[] addAll(byte[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        byte[] result = ArrayKits.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, bytes.length);
        buffer.flip();
        return buffer.getLong();
    }

    public static byte[] intToBytes(int value) {
        byte[] src = new byte[4];
        src[3] = (byte)(value >> 24 & 0xFF);
        src[2] = (byte)(value >> 16 & 0xFF);
        src[1] = (byte)(value >> 8 & 0xFF);
        src[0] = (byte)(value & 0xFF);
        return src;
    }

    public static int bytesToInt(byte[] src, int offset) {
        int value = src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
        return value;
    }

    public static byte[] sub(byte[] array, int start, int end) {
        int length = ArrayKits.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new byte[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new byte[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean noRepeateFinal(List<byte[]> bytess) {
        ArrayList<byte[]> temps = new ArrayList<byte[]>(bytess.size());
        for (byte[] bytes : bytess) {
            for (byte[] temp : temps) {
                if (BytesUtil.compare(temp, bytes) != 0) continue;
                return false;
            }
            temps.add(bytes);
        }
        return true;
    }

    public static boolean noRepeate(byte[][] bytess) {
        HashMap<Integer, List> map = new HashMap<Integer, List>(bytess.length);
        for (byte[] bytes : bytess) {
            HashEnty hashEnty = new HashEnty();
            hashEnty.hashCode = ArrayKits.hashCode(bytes);
            hashEnty.bytes = bytes;
            int hash = ArrayKits.hash(hashEnty.hashCode, bytess.length);
            List list = map.computeIfAbsent(hash, k -> new ArrayList());
            list.add(hashEnty);
        }
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            int key = (Integer)object.next();
            List list = (List)map.get(key);
            if (list.size() <= 1 || ArrayKits.noRepeate2(list)) continue;
            return false;
        }
        return true;
    }

    public static boolean noRepeate2(List<HashEnty> bytess) {
        HashMap<Integer, List> map = new HashMap<Integer, List>(bytess.size());
        for (HashEnty hashEnty : bytess) {
            int hash = ArrayKits.hash(hashEnty.hashCode, bytess.size());
            List list = map.computeIfAbsent(hash, k -> new ArrayList());
            list.add(hashEnty.bytes);
        }
        Iterator<HashEnty> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            List list = (List)map.get(key);
            if (list.size() <= 1 || ArrayKits.noRepeateFinal(list)) continue;
            return false;
        }
        return true;
    }

    private static int hash(Object key, int size) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return size - 1 & n;
    }

    private static int hashCode(byte[] value) {
        int h = 0;
        byte[] val = value;
        for (int i = 0; i < value.length; ++i) {
            h = 31 * h + val[i];
        }
        return h;
    }

    public static class HashEnty {
        public int hashCode;
        public byte[] bytes;
    }
}

