/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class BinLog {
    private RocksDB rocksDB;
    private final WriteOptions writeOptions = new WriteOptions();
    private AtomicLong index = new AtomicLong(0L);
    private volatile long oldestIndex = 0L;
    private static final byte[] Index_Key = "I".getBytes();
    private static final byte[] Long_Key = "L".getBytes();

    private long incr(long increment) {
        return this.index.addAndGet(increment);
    }

    private synchronized long[] incrs(int num) {
        long[] indexs = new long[num];
        for (int i = 0; i < indexs.length; ++i) {
            indexs[i] = this.incr(1L);
        }
        return indexs;
    }

    public long index() {
        return this.index.get();
    }

    public long oldestIndex() {
        return this.oldestIndex;
    }

    public void addLog(List<byte[]> logs) throws RocksDBException {
        long[] indexs = this.incrs(logs.size());
        try (WriteBatch batch = new WriteBatch();){
            for (int i = 0; i < logs.size(); ++i) {
                batch.put(ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(indexs[i])), logs.get(i));
            }
            this.rocksDB.write(this.writeOptions, batch);
        }
    }

    public synchronized void clear(int num) throws RocksDBException {
        byte[] start_b = ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(this.oldestIndex));
        byte[] end_b = ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(this.oldestIndex + (long)num + 1L));
        this.rocksDB.deleteRange(start_b, end_b);
    }

    public synchronized void clearBefore(int index) throws RocksDBException {
        byte[] start_b = ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(this.oldestIndex));
        byte[] end_b = ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(index));
        this.rocksDB.deleteRange(start_b, end_b);
    }

    public List<Entry> logs(long start, int limit) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try (RocksIterator iterator = this.rocksDB.newIterator();){
            byte[] start_b = ArrayKits.addAll(Long_Key, ArrayKits.longToBytes(start));
            iterator.seek(start_b);
            for (int i = 0; iterator.isValid() && i < limit; ++i) {
                byte[] key = iterator.key();
                if (!BytesUtil.checkHead(Long_Key, key)) {
                    break;
                }
                long index = ArrayKits.bytesToLong(ArrayKits.sub(key, Long_Key.length, key.length - 1));
                Entry entry = new Entry(index, iterator.value());
                entries.add(entry);
            }
        }
        return entries;
    }

    public BinLog(RocksDB rocksDB) {
        this.rocksDB = rocksDB;
        try (RocksIterator iterator = rocksDB.newIterator();){
            iterator.seek(Long_Key);
            if (iterator.isValid()) {
                byte[] start_b = iterator.key();
                if (BytesUtil.checkHead(Long_Key, start_b)) {
                    iterator.seekToLast();
                    byte[] end_b = iterator.key();
                    long start = ArrayKits.bytesToLong(ArrayKits.sub(start_b, Long_Key.length, start_b.length));
                    long end = ArrayKits.bytesToLong(ArrayKits.sub(end_b, Long_Key.length, end_b.length));
                    this.oldestIndex = start;
                    this.index.set(end);
                }
            } else {
                this.oldestIndex = 0L;
            }
        }
    }

    public static class Entry
    extends REntry {
        private long index;
        private byte[] value;

        public long getIndex() {
            return this.index;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $index = this.getIndex();
            result = result * 59 + (int)($index >>> 32 ^ $index);
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "BinLog.Entry(index=" + this.getIndex() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(long index, byte[] value) {
            this.index = index;
            this.value = value;
        }
    }
}

