/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import top.thinkin.lightd.base.KeyLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.SegmentStrLock;

public class KeyDoubletLock
implements KeyLock {
    private final ConcurrentHashMap<String, LockEntity> map;
    protected final SegmentStrLock lock;
    private int maxSize;

    public int getSize() {
        return this.map.size();
    }

    public KeyDoubletLock(int maxSize) {
        this.maxSize = maxSize;
        this.lock = new SegmentStrLock(16);
        this.map = new ConcurrentHashMap(maxSize * 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyInLock(String key) {
        LockEntity lockEntity = this.lock.lock(key);
        try {
            LockEntity reentrantLock = this.map.get(key);
            if (reentrantLock == null) {
                boolean bl = false;
                return bl;
            }
            if (reentrantLock.getLockSize() == 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock(lockEntity);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockEntity lock(String key) {
        LockEntity reentrantLock;
        LockEntity lockEntity = this.lock.lock(key);
        try {
            reentrantLock = this.map.get(key);
            if (reentrantLock == null) {
                reentrantLock = new LockEntity(key, this);
                this.map.put(key, reentrantLock);
            }
            reentrantLock.addSize();
        }
        finally {
            this.lock.unlock(lockEntity);
        }
        reentrantLock.lock();
        reentrantLock.setTime();
        return reentrantLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(LockEntity reentrantLock) {
        LockEntity lockEntity = this.lock.lock(reentrantLock.getKey());
        try {
            LockEntity reentrantLock_get;
            reentrantLock.unlock();
            reentrantLock.subSize();
            if (this.map.size() > this.maxSize * 5 && reentrantLock.equals(reentrantLock_get = this.map.get(reentrantLock.getKey())) && reentrantLock.getLockSize() == 0) {
                this.map.remove(reentrantLock.getKey());
            }
        }
        finally {
            this.lock.unlock(lockEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(int time, String key) {
        LockEntity lockEntity = this.lock.lock(key);
        try {
            LockEntity reentrantLock = this.map.get(key);
            if (reentrantLock != null && time - reentrantLock.getTime() > 30 && reentrantLock.getLockSize() == 0) {
                this.map.remove(key);
            }
        }
        finally {
            this.lock.unlock(lockEntity);
        }
    }

    public void clear() {
        if (this.map.size() <= this.maxSize) {
            return;
        }
        Iterator iter = ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
        int time = (int)(System.currentTimeMillis() / 1000L);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.clear(time, key);
        }
    }
}

