/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.security.AccessController;
import java.util.Locale;

public class Platform {
    private static final boolean IS_WINDOWS = Platform.isWindows0();

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    private static boolean isWindows0() {
        boolean windows = Platform.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (windows) {
            // empty if block
        }
        return windows;
    }

    public static String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(() -> System.getProperty(key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null) {
            return def;
        }
        return value;
    }
}

