/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.BinLog;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.KeySegmentLockManager;
import top.thinkin.lightd.base.VersionSequence;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DBAbs;
import top.thinkin.lightd.db.RBase;
import top.thinkin.lightd.db.RKv;
import top.thinkin.lightd.db.RList;
import top.thinkin.lightd.db.RMap;
import top.thinkin.lightd.db.RSet;
import top.thinkin.lightd.db.RSnapshot;
import top.thinkin.lightd.db.TimerStore;
import top.thinkin.lightd.db.ZSet;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;
import top.thinkin.lightd.kit.FileZipUtils;
import top.thinkin.lightd.kit.ZipUtil;

public class DB
extends DBAbs {
    private static final Logger log = LoggerFactory.getLogger(DB.class);
    static final byte[] DB_VERSION = "V0.0.2".getBytes();
    public static String BACK_FILE_SUFFIX = ".kit";
    protected static Charset charset = Charset.forName("UTF-8");
    private VersionSequence versionSequence;
    private ZSet zSet;
    private RMap map;
    private RSet set;
    private RList list;
    private String dir;
    private RKv rKv;
    private static final byte[] DEL_HEAD = "D".getBytes();
    private RocksDB binLogDB;
    private BinLog binLog;
    ScheduledThreadPoolExecutor stp = new ScheduledThreadPoolExecutor(4);

    private DB() {
    }

    public synchronized void close() throws InterruptedException, KitDBException {
        try (CloseLock ignored = this.closeCheck();){
            this.open = false;
            if (this.stp != null) {
                this.stp.shutdown();
                this.stp.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            if (this.rocksDB != null) {
                this.rocksDB.close();
                this.readOptions.close();
                this.writeOptions.close();
                this.options.close();
                for (ColumnFamilyOptions cfOptions : this.cfOptionsList) {
                    cfOptions.close();
                }
                this.metaHandle.close();
                this.defHandle.close();
            }
        }
    }

    public synchronized void stop() throws InterruptedException, KitDBException {
        try (CloseLock ignored = this.closeCheck();){
            this.open = false;
            if (this.stp != null) {
                this.stp.shutdown();
                this.stp.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            if (this.rocksDB != null) {
                this.rocksDB.close();
                this.metaHandle.close();
                this.defHandle.close();
            }
        }
    }

    public RSnapshot createSnapshot() {
        return new RSnapshot(this.rocksDB.getSnapshot());
    }

    public VersionSequence versionSequence() {
        return this.versionSequence;
    }

    public synchronized void clear() {
        try (RocksIterator iterator = this.rocksDB.newIterator();){
            iterator.seek(DEL_HEAD);
            while (iterator.isValid() && this.open) {
                Object meta;
                byte[] key_bs = iterator.key();
                if (DEL_HEAD[0] != key_bs[0]) {
                    break;
                }
                byte[] value = iterator.value();
                iterator.next();
                byte[] rel_key_bs = ArrayKits.sub(key_bs, 1, key_bs.length - 4);
                if (RList.HEAD_B[0] == rel_key_bs[0]) {
                    RList.MetaV metaV = RList.MetaVD.build(value).convertMeta();
                    this.list.deleteByClear(rel_key_bs, metaV);
                }
                if (RMap.HEAD_B[0] == rel_key_bs[0]) {
                    meta = RMap.MetaD.build(value).convertMeta();
                    this.map.deleteByClear(rel_key_bs, (RMap.Meta)meta);
                }
                if (RSet.HEAD_B[0] == rel_key_bs[0]) {
                    meta = RSet.MetaD.build(value);
                    this.set.deleteByClear(rel_key_bs, (RSet.MetaD)meta);
                }
                if (ZSet.HEAD_B[0] != rel_key_bs[0]) continue;
                meta = ZSet.MetaD.build(value);
                this.zSet.deleteByClear(rel_key_bs, (ZSet.MetaD)meta);
            }
        }
        catch (Exception e) {
            log.error("clear error", (Throwable)e);
        }
    }

    public ZSet getzSet() {
        return this.zSet;
    }

    public RMap getMap() {
        return this.map;
    }

    public RSet getSet() {
        return this.set;
    }

    public RList getList() {
        return this.list;
    }

    public synchronized void checkTTL() {
        try {
            int end = (int)(System.currentTimeMillis() / 1000L);
            for (int i = 0; i < 10; ++i) {
                TimerStore.rangeDel(this, KeyEnum.COLLECT_TIMER.getKey(), 0, end, 500, dataList -> {
                    List outTimeKeys = dataList;
                    DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
                    for (TimerStore.TData outTimeKey : outTimeKeys) {
                        DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
                        byte[] value = outTimeKey.getValue();
                        RBase.TimerCollection timerCollection = RBase.getTimerCollection(value);
                        if (RList.HEAD_B[0] == timerCollection.meta_b[0]) {
                            this.list.deleteTTL(outTimeKey.getTime(), timerCollection.key_b, timerCollection.meta_b);
                        }
                        if (RMap.HEAD_B[0] == timerCollection.meta_b[0]) {
                            this.map.deleteTTL(outTimeKey.getTime(), timerCollection.key_b, timerCollection.meta_b);
                        }
                        if (RSet.HEAD_B[0] == timerCollection.meta_b[0]) {
                            this.set.deleteTTL(outTimeKey.getTime(), timerCollection.key_b, timerCollection.meta_b);
                        }
                        if (ZSet.HEAD_B[0] != timerCollection.meta_b[0]) continue;
                        this.zSet.deleteTTL(outTimeKey.getTime(), timerCollection.key_b, timerCollection.meta_b);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("clearKV error", (Throwable)e);
        }
    }

    public synchronized void checkKVTTL() {
    }

    public synchronized void clearKV() {
        try {
            int end = (int)(System.currentTimeMillis() / 1000L);
            for (int i = 0; i < 10; ++i) {
                DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
                List<TimerStore.TData> outTimeKeys = TimerStore.rangeDel(this, KeyEnum.KV_TIMER.getKey(), 0, end, 2000);
                if (outTimeKeys.size() == 0) {
                    return;
                }
                for (TimerStore.TData outTimeKey : outTimeKeys) {
                    DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
                    byte[] key_bs = outTimeKey.getValue();
                    if (RKv.HEAD_B[0] != key_bs[0]) continue;
                    this.rKv.delCheckTTL(new String(ArrayKits.sub(key_bs, 1, key_bs.length + 1), charset), outTimeKey.getTime());
                }
            }
        }
        catch (Exception e) {
            log.error("clearKV error", (Throwable)e);
        }
    }

    public synchronized void compaction() {
        try {
            this.rocksDB.compactRange();
        }
        catch (Exception e) {
            log.error("compaction error", (Throwable)e);
        }
    }

    public synchronized String backupDB(String path, String backName) throws RocksDBException, IOException {
        Random r = new Random();
        String sourceDir = File.separator + "tempsp" + r.nextInt(999);
        String tempPath = path + sourceDir;
        File tempFile = new File(tempPath);
        FileZipUtils.delFile(tempFile);
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.rocksDB);){
            checkpoint.createCheckpoint(tempPath);
        }
        String fileName = backName + BACK_FILE_SUFFIX;
        String backPath = path + File.separator + fileName;
        try (FileOutputStream fOut = new FileOutputStream(backPath);
             ZipOutputStream zOut = new ZipOutputStream(fOut);){
            ZipUtil.compressDirectoryToZipFile(tempPath, "", zOut);
            fOut.getFD().sync();
        }
        FileZipUtils.delFile(tempFile);
        return backPath;
    }

    public static void releaseBackup(String path, String targetpath) throws IOException {
        ZipUtil.unzipFile(path, targetpath);
    }

    public static synchronized DB build(String dir) throws KitDBException {
        return DB.build(dir, true);
    }

    public static synchronized DB build(String dir, boolean autoclear) throws KitDBException {
        DB db;
        try {
            DBOptions options;
            db = new DB();
            db.dir = dir;
            db.options = options = DB.getDbOptions();
            ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>();
            db.rocksDB = RocksDB.open((DBOptions)options, (String)dir, db.getColumnFamilyDescriptor(), cfHandles);
            DB.setDB(autoclear, db, cfHandles, false);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
        return db;
    }

    public static synchronized DB readOnly(String dir) throws KitDBException {
        DB db;
        try {
            DBOptions options;
            db = new DB();
            db.dir = dir;
            db.options = options = DB.getDbOptions();
            ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>();
            db.rocksDB = RocksDB.openReadOnly((DBOptions)options, (String)dir, db.getColumnFamilyDescriptor(), cfHandles);
            DB.setDB(false, db, cfHandles, true);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
        return db;
    }

    public static synchronized DB buildTransactionDB(String dir, boolean autoclear) throws KitDBException {
        DB db;
        try {
            DBOptions options;
            db = new DB();
            db.dir = dir;
            db.options = options = DB.getDbOptions();
            ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>();
            TransactionDBOptions transactionDBOptions = new TransactionDBOptions();
            TransactionDB rocksDB = TransactionDB.open((DBOptions)options, (TransactionDBOptions)transactionDBOptions, (String)dir, db.getColumnFamilyDescriptor(), cfHandles);
            db.openTransaction = true;
            db.rocksDB = rocksDB;
            DB.setDB(autoclear, db, cfHandles, false);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
        return db;
    }

    private static DBOptions getDbOptions() {
        DBOptions options = new DBOptions();
        options.setCreateIfMissing(true);
        options.setCreateMissingColumnFamilies(true);
        return options;
    }

    public synchronized void open(String dir, boolean autoclear, boolean readOnly) throws KitDBException {
        DAssert.isTrue(!this.open, ErrorType.DB_CLOSE, "db is closed");
        try {
            ArrayList cfHandles = new ArrayList();
            if (this.openTransaction) {
                TransactionDBOptions transactionDBOptions = new TransactionDBOptions();
                this.rocksDB = TransactionDB.open((DBOptions)this.options, (TransactionDBOptions)transactionDBOptions, (String)dir, this.getColumnFamilyDescriptor(), cfHandles);
            } else {
                this.rocksDB = RocksDB.open((DBOptions)this.options, (String)dir, this.getColumnFamilyDescriptor(), cfHandles);
            }
            this.metaHandle = (ColumnFamilyHandle)cfHandles.get(0);
            this.defHandle = (ColumnFamilyHandle)cfHandles.get(1);
            this.stp = new ScheduledThreadPoolExecutor(4);
            if (!readOnly) {
                if (autoclear) {
                    this.stp.scheduleWithFixedDelay(this::clear, 2L, 2L, TimeUnit.SECONDS);
                    this.stp.scheduleWithFixedDelay(this::clearKV, 1L, 1L, TimeUnit.SECONDS);
                }
                this.stp.scheduleWithFixedDelay(this::checkTTL, 1L, 1L, TimeUnit.SECONDS);
                this.stp.scheduleWithFixedDelay(this::compaction, 30L, 30L, TimeUnit.SECONDS);
            }
            this.keySegmentLockManager.start(this.stp);
            this.open = true;
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
        this.dir = dir;
    }

    public synchronized void open(boolean autoclear, boolean readOnly) throws KitDBException {
        this.open(this.dir, autoclear, readOnly);
    }

    private static void setDB(boolean autoclear, DB db, List<ColumnFamilyHandle> cfHandles, boolean readOnly) throws RocksDBException, KitDBException {
        db.metaHandle = cfHandles.get(0);
        db.defHandle = cfHandles.get(1);
        db.versionSequence = new VersionSequence(db);
        byte[] version = db.rocksDB.get("version".getBytes());
        if (version == null) {
            if (!readOnly) {
                db.rocksDB.put("version".getBytes(), DB_VERSION);
            } else {
                DAssert.isTrue(false, ErrorType.STORE_VERSION, "Store versions must be " + new String(DB_VERSION) + ", but now is null");
            }
        } else {
            DAssert.isTrue(BytesUtil.compare(version, DB_VERSION) == 0, ErrorType.STORE_VERSION, "Store versions must be " + new String(DB_VERSION) + ", but now is " + new String(version));
        }
        db.writeOptions = new WriteOptions();
        if (!readOnly) {
            if (autoclear) {
                db.stp.scheduleWithFixedDelay(db::clear, 2L, 2L, TimeUnit.SECONDS);
                db.stp.scheduleWithFixedDelay(db::clearKV, 1L, 1L, TimeUnit.SECONDS);
            }
            db.stp.scheduleWithFixedDelay(db::checkTTL, 1L, 1L, TimeUnit.SECONDS);
            db.stp.scheduleWithFixedDelay(db::compaction, 5L, 5L, TimeUnit.SECONDS);
        }
        Options optionsBinLog = new Options();
        optionsBinLog.setCreateIfMissing(true);
        db.binLogDB = null;
        db.keySegmentLockManager = new KeySegmentLockManager(db.stp);
        db.rKv = new RKv(db);
        db.zSet = new ZSet(db);
        db.set = new RSet(db);
        db.list = new RList(db);
        db.map = new RMap(db);
        db.open = true;
    }

    public RKv getrKv() {
        return this.rKv;
    }

    public BinLog getBinLog() {
        return this.binLog;
    }

    KeySegmentLockManager getKeySegmentLockManager() {
        return this.keySegmentLockManager;
    }

    public String getDir() {
        return this.dir;
    }

    static {
        RocksDB.loadLibrary();
    }
}

