/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.DBCommand;
import top.thinkin.lightd.base.DBCommandChunk;
import top.thinkin.lightd.base.DBCommandChunkType;
import top.thinkin.lightd.base.KeySegmentLockManager;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TableConfig;
import top.thinkin.lightd.base.TransactionEntity;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.BytesUtil;

public abstract class DBAbs {
    private static final Logger log = LoggerFactory.getLogger(DBAbs.class);
    protected RocksDB rocksDB;
    protected boolean openTransaction = false;
    protected volatile boolean open = false;
    protected KeySegmentLockManager keySegmentLockManager;
    protected WriteOptions writeOptions;
    protected DBOptions options;
    protected ReadOptions readOptions = new ReadOptions();
    protected ColumnFamilyHandle metaHandle;
    protected ColumnFamilyHandle defHandle;
    protected ThreadLocal<List<DBCommand>> threadLogs = new ThreadLocal();
    protected ThreadLocal<TransactionEntity> TRANSACTION_ENTITY = new ThreadLocal();
    public final ThreadLocal<Boolean> IS_STATR_TX = ThreadLocal.withInitial(() -> false);
    protected final ReadWriteLock CLOSE_LOCK = new ReentrantReadWriteLock(true);
    protected final List<ColumnFamilyOptions> cfOptionsList = new ArrayList<ColumnFamilyOptions>();
    public volatile FunctionCommit functionCommit = dbCommandChunk -> {
        DBCommandChunkType dbCommandChunkType = dbCommandChunk.getType();
        switch (dbCommandChunkType) {
            case NOM_COMMIT: {
                this.commit(dbCommandChunk.getCommands());
                break;
            }
            case TX_LOGS: {
                this.commit(dbCommandChunk.getCommands());
                break;
            }
            case TX_COMMIT: {
                this.commitTX(dbCommandChunk.getEntity());
                break;
            }
            case TX_ROLLBACK: {
                this.rollbackTX(dbCommandChunk.getEntity());
                break;
            }
            case SIMPLE_COMMIT: {
                this.simpleCommit(dbCommandChunk.getCommands());
                break;
            }
            default: {
                throw new KitDBException(ErrorType.NULL, "DBCommandChunkType non-existent!");
            }
        }
    };

    public RocksDB rocksDB() {
        return this.rocksDB;
    }

    protected CloseLock closeCheck() throws KitDBException {
        Lock lock = this.CLOSE_LOCK.readLock();
        lock.lock();
        try {
            DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
        }
        catch (KitDBException e) {
            lock.unlock();
            throw e;
        }
        return new CloseLock(lock);
    }

    protected CloseLock closeDo() throws KitDBException {
        Lock lock = this.CLOSE_LOCK.writeLock();
        try {
            DAssert.isTrue(this.open, ErrorType.DB_CLOSE, "db is closed");
        }
        catch (KitDBException e) {
            lock.unlock();
            throw e;
        }
        return new CloseLock(lock);
    }

    protected DBAbs() {
    }

    public void commitTX() throws KitDBException {
        block6: {
            try {
                DAssert.isTrue(this.IS_STATR_TX.get(), ErrorType.TX_NOT_START, "Transaction have not started");
                TransactionEntity entity = this.TRANSACTION_ENTITY.get();
                if (entity.getCount() > 0) {
                    entity.subCount();
                    break block6;
                }
                try {
                    DBCommandChunk dbCommandChunk = new DBCommandChunk(DBCommandChunkType.TX_COMMIT, entity);
                    this.functionCommit.call(dbCommandChunk);
                }
                finally {
                    this.IS_STATR_TX.set(false);
                    entity.reset();
                }
            }
            catch (RocksDBException e) {
                throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
            }
        }
    }

    public void commitTX(TransactionEntity entity) throws RocksDBException {
        entity.getTransaction().commit();
    }

    public void rollbackTX() throws KitDBException {
        block9: {
            try {
                if (!this.IS_STATR_TX.get().booleanValue()) {
                    return;
                }
                TransactionEntity entity = this.TRANSACTION_ENTITY.get();
                if (entity.getCount() > 0) {
                    entity.subCount();
                    break block9;
                }
                try {
                    DBCommandChunk dbCommandChunk = new DBCommandChunk(DBCommandChunkType.TX_ROLLBACK, entity);
                    this.functionCommit.call(dbCommandChunk);
                }
                catch (RocksDBException e) {
                    this.rollbackTX(entity);
                    throw e;
                }
                finally {
                    this.IS_STATR_TX.set(false);
                    entity.reset();
                }
            }
            catch (RocksDBException e) {
                throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
            }
        }
    }

    public void rollbackTX(TransactionEntity entity) throws RocksDBException {
        entity.getTransaction().rollback();
    }

    public void start() {
        List<DBCommand> logs = this.threadLogs.get();
        if (logs == null) {
            logs = new ArrayList<DBCommand>();
            this.threadLogs.set(logs);
        }
        logs.clear();
    }

    public void startTran() throws KitDBException {
        DAssert.isTrue(this.openTransaction, ErrorType.NOT_TX_DB, "this db is not a Transaction DB");
        if (!this.IS_STATR_TX.get().booleanValue()) {
            TransactionEntity transactionEntity = new TransactionEntity();
            TransactionDB rocksDB = (TransactionDB)this.rocksDB();
            Transaction transaction = rocksDB.beginTransaction(this.writeOptions);
            transactionEntity.setTransaction(transaction);
            this.TRANSACTION_ENTITY.set(transactionEntity);
            this.IS_STATR_TX.set(true);
        } else {
            this.TRANSACTION_ENTITY.get().addCount();
        }
    }

    protected void addLockEntity(LockEntity lockEntity) {
        if (this.IS_STATR_TX.get().booleanValue()) {
            TransactionEntity transactionEntity = this.TRANSACTION_ENTITY.get();
            transactionEntity.addLock(lockEntity);
        }
    }

    public void checkKey() throws KitDBException {
        DAssert.isTrue(this.openTransaction, ErrorType.NOT_TX_DB, "this db is not a Transaction DB");
    }

    public void commit(List<DBCommand> logs) throws KitDBException {
        block15: {
            try {
                if (this.IS_STATR_TX.get().booleanValue()) {
                    Transaction transaction = this.TRANSACTION_ENTITY.get().getTransaction();
                    try (WriteBatch batch = new WriteBatch();){
                        this.setLogs(logs, batch);
                        transaction.rebuildFromWriteBatch(batch);
                        break block15;
                    }
                }
                this.simpleCommit(logs);
            }
            catch (RocksDBException e) {
                throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
            }
        }
    }

    public void commit(List<DBCommand> logs, TransactionEntity transactionEntity) throws KitDBException {
        try (WriteBatch batch = new WriteBatch();){
            this.setLogs(logs, batch);
            transactionEntity.getTransaction().rebuildFromWriteBatch(batch);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
    }

    public void simpleCommit(List<DBCommand> logs) throws KitDBException, RocksDBException {
        try (WriteBatch batch = new WriteBatch();){
            this.setLogs(logs, batch);
            this.rocksDB().write(this.writeOptions(), batch);
        }
    }

    protected void commitLocal() throws KitDBException {
        try {
            List<DBCommand> logs = this.threadLogs.get();
            try {
                this.simpleCommit(logs);
            }
            finally {
                logs.clear();
            }
        }
        catch (Exception e) {
            throw new KitDBException(ErrorType.STROE_ERROR, e);
        }
    }

    protected void commit() throws KitDBException {
        try {
            DBCommandChunk dbCommandChunk = new DBCommandChunk();
            if (this.IS_STATR_TX.get().booleanValue()) {
                TransactionEntity entity = this.TRANSACTION_ENTITY.get();
                dbCommandChunk.setType(DBCommandChunkType.TX_LOGS);
                dbCommandChunk.setEntity(entity);
            } else {
                dbCommandChunk.setType(DBCommandChunkType.NOM_COMMIT);
            }
            List<DBCommand> logs = this.threadLogs.get();
            dbCommandChunk.setCommands(logs);
            try {
                this.functionCommit.call(dbCommandChunk);
            }
            finally {
                logs.clear();
            }
        }
        catch (Exception e) {
            throw new KitDBException(ErrorType.STROE_ERROR, e);
        }
    }

    protected WriteOptions writeOptions() {
        return this.writeOptions;
    }

    protected void release() {
        List<DBCommand> logs = this.threadLogs.get();
        if (logs != null) {
            logs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simplePut(byte[] key, byte[] value, SstColumnFamily columnFamily) throws KitDBException {
        ArrayList<DBCommand> logs = new ArrayList<DBCommand>(1);
        logs.add(DBCommand.update(key, value, columnFamily));
        DBCommandChunk dbCommandChunk = new DBCommandChunk(DBCommandChunkType.SIMPLE_COMMIT, logs);
        try {
            try {
                this.simpleCommit(logs);
            }
            finally {
                logs.clear();
            }
        }
        catch (Exception e) {
            throw new KitDBException(ErrorType.STROE_ERROR, e);
        }
    }

    protected void putDB(byte[] key, byte[] value, SstColumnFamily columnFamily) {
        List<DBCommand> logs = this.threadLogs.get();
        logs.add(DBCommand.update(key, value, columnFamily));
    }

    protected void deleteDB(byte[] key, SstColumnFamily columnFamily) {
        List<DBCommand> logs = this.threadLogs.get();
        logs.add(DBCommand.delete(key, columnFamily));
    }

    protected void deleteRangeDB(byte[] start, byte[] end, SstColumnFamily columnFamily) {
        List<DBCommand> logs = this.threadLogs.get();
        logs.add(DBCommand.deleteRange(start, end, columnFamily));
    }

    private void setLogs(List<DBCommand> logs, WriteBatch batch) throws KitDBException {
        try {
            for (DBCommand log : logs) {
                switch (log.getType()) {
                    case DELETE: {
                        batch.delete(this.findColumnFamilyHandle(log.getFamily()), log.getKey());
                        break;
                    }
                    case UPDATE: {
                        batch.put(this.findColumnFamilyHandle(log.getFamily()), log.getKey(), log.getValue());
                        break;
                    }
                    case DELETE_RANGE: {
                        batch.deleteRange(this.findColumnFamilyHandle(log.getFamily()), log.getStart(), log.getEnd());
                    }
                }
            }
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
    }

    protected List<ColumnFamilyDescriptor> getColumnFamilyDescriptor() {
        ColumnFamilyOptions cfOptions = TableConfig.createColumnFamilyOptions();
        ColumnFamilyOptions defCfOptions = TableConfig.createDefColumnFamilyOptions();
        this.cfOptionsList.add(cfOptions);
        this.cfOptionsList.add(defCfOptions);
        ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        cfDescriptors.add(new ColumnFamilyDescriptor("R_META".getBytes(), cfOptions));
        cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, defCfOptions));
        return cfDescriptors;
    }

    private ColumnFamilyHandle findColumnFamilyHandle(SstColumnFamily sstColumnFamily) {
        switch (sstColumnFamily) {
            case DEFAULT: {
                return this.defHandle;
            }
            case META: {
                return this.metaHandle;
            }
        }
        throw new IllegalArgumentException("illegal sstColumnFamily: " + sstColumnFamily.name());
    }

    protected byte[] getDB(byte[] key, SstColumnFamily columnFamily) throws KitDBException {
        try {
            if (this.IS_STATR_TX.get().booleanValue()) {
                Transaction transaction = this.TRANSACTION_ENTITY.get().getTransaction();
                return transaction.get(this.findColumnFamilyHandle(columnFamily), this.readOptions, key);
            }
            return this.rocksDB().get(this.findColumnFamilyHandle(columnFamily), key);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
    }

    public byte[] simpleGet(byte[] key, SstColumnFamily columnFamily) throws KitDBException {
        try {
            return this.rocksDB().get(this.findColumnFamilyHandle(columnFamily), key);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
    }

    protected RocksIterator newIterator(SstColumnFamily columnFamily) {
        if (this.IS_STATR_TX.get().booleanValue()) {
            Transaction transaction = this.TRANSACTION_ENTITY.get().getTransaction();
            return transaction.getIterator(this.readOptions, this.findColumnFamilyHandle(columnFamily));
        }
        return this.rocksDB().newIterator(this.findColumnFamilyHandle(columnFamily));
    }

    private static int computeCapacityHint(int estimatedNumberOfItems) {
        return (int)Math.ceil((double)estimatedNumberOfItems * 1.5 + 1.0);
    }

    protected Map<byte[], byte[]> multiGet(List<byte[]> keys, SstColumnFamily columnFamily) throws KitDBException {
        try {
            ArrayList<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(keys.size());
            for (byte[] ignored : keys) {
                columnFamilyHandles.add(this.findColumnFamilyHandle(columnFamily));
            }
            if (this.IS_STATR_TX.get().booleanValue()) {
                Transaction transaction = this.TRANSACTION_ENTITY.get().getTransaction();
                byte[][] keys_bytes = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
                byte[][] values = transaction.multiGet(this.readOptions, columnFamilyHandles, keys_bytes);
                HashMap<byte[], byte[]> keyValueMap = new HashMap<byte[], byte[]>(DBAbs.computeCapacityHint(values.length));
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    keyValueMap.put(keys.get(i), values[i]);
                }
                return keyValueMap;
            }
            return this.rocksDB().multiGet(columnFamilyHandles, keys);
        }
        catch (RocksDBException e) {
            throw new KitDBException(ErrorType.STROE_ERROR, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteHead(byte[] head, SstColumnFamily columnFamily) {
        ReadOptions readOptions = new ReadOptions();
        readOptions.setPrefixSameAsStart(true);
        try (RocksIterator iterator = this.rocksDB().newIterator(this.findColumnFamilyHandle(columnFamily), readOptions);){
            byte[] key;
            iterator.seek(head);
            byte[] end = null;
            byte[] start = iterator.key();
            if (!BytesUtil.checkHead(head, start)) {
                return;
            }
            while (iterator.isValid() && BytesUtil.checkHead(head, key = iterator.key())) {
                end = key;
                iterator.next();
            }
            if (end != null) {
                this.deleteRangeDB(start, end, columnFamily);
                this.deleteDB(end, columnFamily);
            }
        }
    }

    public static interface FunctionCommit {
        public void call(DBCommandChunk var1) throws KitDBException, RocksDBException;
    }
}

