/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import org.rocksdb.RocksIterator;
import top.thinkin.lightd.db.RBase;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class KeyIterator
implements AutoCloseable {
    private final RocksIterator iterator;
    private final byte[] seekHead;
    private boolean finish = false;
    private byte[] now;
    private byte[] next;

    public KeyIterator(RocksIterator iterator, byte[] seekHead) {
        this.iterator = iterator;
        this.seekHead = seekHead;
    }

    public boolean hasNext() {
        if (this.finish) {
            return false;
        }
        byte[] key = this.iterator.key();
        if (key == null || !BytesUtil.checkHead(this.seekHead, key)) {
            this.finish = true;
            return false;
        }
        return this.iterator.isValid();
    }

    public String next() {
        if (!this.iterator.isValid()) {
            return null;
        }
        byte[] cKey = this.iterator.key();
        if (cKey == null) {
            return null;
        }
        this.iterator.next();
        return new String(ArrayKits.sub(cKey, 1, cKey.length), RBase.charset);
    }

    public byte[] getSeek() {
        return this.seekHead;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

