/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.KeyLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.TimerStore;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;

public abstract class RBase {
    private static final Logger log = LoggerFactory.getLogger(RBase.class);
    protected DB db;
    protected final boolean isLog;
    protected static Charset charset = Charset.forName("UTF-8");
    protected int DEF_TX_TIME_OUT = 5000;
    protected KeyLock lock;

    public RBase(boolean isLog) {
        this.isLog = isLog;
    }

    public RBase() {
        this.isLog = false;
    }

    public void start() {
        this.db.start();
    }

    public CloseLock checkClose() throws KitDBException {
        return this.db.closeCheck();
    }

    protected void setTimer(KeyEnum keyEnum, int time, byte[] value) {
        TimerStore.put(this, keyEnum.getKey(), time, value);
    }

    protected void setTimerCollection(KeyEnum keyEnum, int time, byte[] key_b, byte[] meta_b) {
        byte[] key_b_size_b = ArrayKits.intToBytes(key_b.length);
        TimerStore.put(this, keyEnum.getKey(), time, ArrayKits.addAll(key_b_size_b, key_b, meta_b));
    }

    protected void delTimerCollection(KeyEnum keyEnum, int time, byte[] key_b, byte[] meta_b) {
        byte[] key_b_size_b = ArrayKits.intToBytes(key_b.length);
        TimerStore.del(this, keyEnum.getKey(), time, ArrayKits.addAll(key_b_size_b, key_b, meta_b));
    }

    protected void checkTxRange() throws KitDBException {
        if (!this.db.openTransaction) {
            return;
        }
        DAssert.isTrue((Boolean)this.db.IS_STATR_TX.get() == false, ErrorType.TX_ERROR, "This operation can't execute  in a transaction KitDB");
        this.db.checkKey();
    }

    protected LockEntity lock(String key) {
        LockEntity lockEntity = this.lock.lock(key);
        this.db.addLockEntity(lockEntity);
        return lockEntity;
    }

    protected void unlock(LockEntity lockEntity) {
        if (((Boolean)this.db.IS_STATR_TX.get()).booleanValue()) {
            return;
        }
        this.lock.unlock(lockEntity);
    }

    protected void checkTxStart() throws KitDBException {
        if (this.db.openTransaction) {
            this.db.startTran();
        }
    }

    protected void checkTxCommit() throws KitDBException {
        if (this.db.openTransaction) {
            this.db.commitTX();
        }
    }

    protected void checkTxRollBack() throws KitDBException {
        if (this.db.openTransaction) {
            this.db.rollbackTX();
        }
    }

    protected abstract TxLock getTxLock(String var1);

    protected static TimerCollection getTimerCollection(byte[] value) {
        byte[] key_b_size_b = ArrayKits.sub(value, 0, 4);
        int size = ArrayKits.bytesToInt(key_b_size_b, 0);
        TimerCollection timerCollection = new TimerCollection();
        timerCollection.key_b = ArrayKits.sub(value, 4, 4 + size);
        timerCollection.meta_b = ArrayKits.sub(value, 4 + size, value.length);
        return timerCollection;
    }

    protected void delTimer(KeyEnum keyEnum, int time, byte[] value) {
        TimerStore.del(this, keyEnum.getKey(), time, value);
    }

    protected void commit() throws KitDBException {
        this.db.commit();
    }

    protected void commitLocal() throws KitDBException {
        this.db.commitLocal();
    }

    protected void release() {
        this.db.release();
    }

    protected void putDB(byte[] key, byte[] value, SstColumnFamily columnFamily) {
        this.db.putDB(key, value, columnFamily);
    }

    public void deleteDB(byte[] key, SstColumnFamily columnFamily) {
        this.db.deleteDB(key, columnFamily);
    }

    protected void deleteRangeDB(byte[] start, byte[] end, SstColumnFamily columnFamily) {
        this.db.deleteRangeDB(start, end, columnFamily);
    }

    protected byte[] getDB(byte[] key, SstColumnFamily columnFamily) throws KitDBException {
        return this.db.getDB(key, columnFamily);
    }

    protected RocksIterator newIterator(SstColumnFamily columnFamily) {
        return this.db.newIterator(columnFamily);
    }

    protected Map<byte[], byte[]> multiGet(List<byte[]> keys, SstColumnFamily columnFamily) throws KitDBException {
        return this.db.multiGet(keys, columnFamily);
    }

    protected void deleteHead(byte[] head, SstColumnFamily columnFamily) {
        this.db.deleteHead(head, columnFamily);
    }

    public static class TimerCollection {
        public byte[] key_b;
        public byte[] meta_b;
    }
}

