/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import top.thinkin.lightd.base.MetaAbs;
import top.thinkin.lightd.base.MetaDAbs;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.KeyIterator;
import top.thinkin.lightd.db.RBase;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.db.RIterator;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;

public abstract class RCollection
extends RBase {
    public RCollection(DB db, boolean isLog, int lockSize) {
        super(isLog);
        this.db = db;
        this.lock = db.getKeySegmentLockManager().createLock(2000);
    }

    protected abstract <T extends MetaAbs> T getMeta(byte[] var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFast(byte[] key_b, MetaAbs metaV) throws KitDBException {
        this.start();
        try {
            Object metaVD = metaV.convertMetaBytes();
            this.putDB(ArrayKits.addAll("D".getBytes(charset), key_b, ((MetaDAbs)metaVD).getVersion()), ((MetaDAbs)metaVD).toBytes(), SstColumnFamily.DEFAULT);
            this.deleteDB(key_b, SstColumnFamily.META);
            this.commit();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTTL(byte[] key_b, MetaAbs metaV, int version) throws KitDBException {
        this.start();
        try {
            if (metaV.getVersion() == version) {
                this.deleteDB(key_b, SstColumnFamily.META);
            }
            Object metaVD = metaV.convertMetaBytes();
            this.putDB(ArrayKits.addAll("D".getBytes(charset), key_b, ((MetaDAbs)metaVD).getVersion()), ((MetaDAbs)metaVD).toBytes(), SstColumnFamily.DEFAULT);
            this.commitLocal();
        }
        finally {
            this.release();
        }
    }

    protected KeyIterator getKeyIterator(byte[] head) {
        RocksIterator iterator = this.newIterator(SstColumnFamily.META);
        iterator.seek(head);
        KeyIterator keyIterator = new KeyIterator(iterator, head);
        return keyIterator;
    }

    abstract <T extends RCollection> RIterator<T> iterator(String var1) throws Exception;

    abstract void delete(String var1) throws Exception;

    public abstract KeyIterator getKeyIterator() throws Exception;

    abstract int getTtl(String var1) throws Exception;

    abstract void delTtl(String var1) throws Exception;

    abstract void ttl(String var1, int var2) throws Exception;

    abstract boolean isExist(String var1) throws RocksDBException, KitDBException;

    abstract int size(String var1) throws Exception;

    abstract <E extends REntry> E getEntry(RocksIterator var1) throws KitDBException;
}

