/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import org.rocksdb.RocksIterator;
import top.thinkin.lightd.db.RCollection;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.BytesUtil;

public class RIterator<R extends RCollection>
implements AutoCloseable {
    private final RocksIterator iterator;
    private final R rCollection;
    private final byte[] seekHead;
    private boolean finish = false;

    public RIterator(RocksIterator iterator, R rCollection, byte[] seekHead) {
        this.iterator = iterator;
        this.rCollection = rCollection;
        this.seekHead = seekHead;
    }

    public boolean hasNext() {
        if (this.finish) {
            return false;
        }
        byte[] key = this.iterator.key();
        if (key == null || !BytesUtil.checkHead(this.seekHead, key)) {
            this.finish = true;
            return false;
        }
        return this.iterator.isValid();
    }

    public <E extends REntry> E next() throws KitDBException {
        if (!this.iterator.isValid()) {
            return null;
        }
        Object entry = ((RCollection)this.rCollection).getEntry(this.iterator);
        this.iterator.next();
        return entry;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

