/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.SegmentStrLock;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.RBase;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class RKv
extends RBase {
    private static final Logger log = LoggerFactory.getLogger(RKv.class);
    public static final String HEAD = KeyEnum.KV_KEY.getKey();
    public static final byte[] HEAD_TTL = KeyEnum.KV_TTL.getBytes();
    public static final byte[] HEAD_B = HEAD.getBytes();

    protected RKv(DB db) {
        this.db = db;
        this.lock = new SegmentStrLock(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, byte[] value) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            LockEntity lockEntity = this.lock.lock(key);
            try {
                this.start();
                byte[] key_b = ArrayKits.addAll(HEAD_B, keyb);
                this.putDB(key_b, value, SstColumnFamily.DEFAULT);
                this.deleteDB(ArrayKits.addAll(HEAD_TTL, keyb), SstColumnFamily.DEFAULT);
                this.commit();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    protected byte[] getKey(String key) throws KitDBException {
        DAssert.notNull(key, ErrorType.NULL, "Key is null");
        return key.getBytes(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long incr(String key, int step, int ttl) throws KitDBException {
        this.checkTxStart();
        try {
            Throwable throwable = null;
            try (CloseLock ignored = this.checkClose();){
                long l;
                byte[] keyb = this.getKey(key);
                LockEntity lockEntity = this.lock.lock(key);
                try {
                    long seq;
                    this.start();
                    byte[] key_b = ArrayKits.addAll(HEAD_B, keyb);
                    byte[] value = this.get(key);
                    if (value == null) {
                        seq = step;
                    } else {
                        DAssert.isTrue(value.length == 8, ErrorType.DATA_LOCK, "value not a incr");
                        seq = ArrayKits.bytesToLong(value) + (long)step;
                    }
                    this.putDB(key_b, ArrayKits.longToBytes(seq), SstColumnFamily.DEFAULT);
                    int time = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                    this.putDB(ArrayKits.addAll(HEAD_TTL, keyb), ArrayKits.intToBytes(time), SstColumnFamily.DEFAULT);
                    this.setTimer(KeyEnum.KV_TIMER, time, key_b);
                    this.commit();
                    this.checkTxCommit();
                    l = seq;
                    this.lock.unlock(lockEntity);
                }
                catch (Throwable throwable2) {
                    try {
                        this.lock.unlock(lockEntity);
                        this.release();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                this.release();
                return l;
            }
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long incr(String key, int step) throws KitDBException {
        this.checkTxStart();
        try {
            Throwable throwable = null;
            try (CloseLock ignored = this.checkClose();){
                long l;
                byte[] keyb = this.getKey(key);
                LockEntity lockEntity = this.lock.lock(key);
                try {
                    long seq;
                    this.start();
                    byte[] key_b = ArrayKits.addAll(HEAD_B, keyb);
                    byte[] value = this.get(key);
                    if (value == null) {
                        seq = step;
                    } else {
                        DAssert.isTrue(value.length == 8, ErrorType.DATA_LOCK, "value not a incr");
                        seq = ArrayKits.bytesToLong(value) + (long)step;
                    }
                    this.putDB(key_b, ArrayKits.longToBytes(seq), SstColumnFamily.DEFAULT);
                    this.commit();
                    this.checkTxCommit();
                    l = seq;
                    this.lock.unlock(lockEntity);
                }
                catch (Throwable throwable2) {
                    try {
                        this.lock.unlock(lockEntity);
                        this.release();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                this.release();
                return l;
            }
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Map<String, byte[]> map) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            try {
                this.start();
                for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                    LockEntity lockEntity = this.lock.lock(entry.getKey());
                    try {
                        byte[] key_b = ArrayKits.addAll(HEAD_B, this.getKey(entry.getKey()));
                        this.putDB(key_b, entry.getValue(), SstColumnFamily.DEFAULT);
                        this.deleteDB(ArrayKits.addAll(HEAD_TTL, this.getKey(entry.getKey())), SstColumnFamily.DEFAULT);
                    }
                    finally {
                        this.lock.unlock(lockEntity);
                    }
                }
                this.commit();
            }
            finally {
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Map<String, byte[]> map, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            int time = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
            try {
                this.start();
                int i = 0;
                for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                    LockEntity lockEntity = this.lock.lock(entry.getKey());
                    try {
                        byte[] key_b = ArrayKits.addAll(HEAD_B, this.getKey(entry.getKey()));
                        this.putDB(key_b, entry.getValue(), SstColumnFamily.DEFAULT);
                        this.putDB(ArrayKits.addAll(HEAD_TTL, this.getKey(entry.getKey())), ArrayKits.intToBytes(time), SstColumnFamily.DEFAULT);
                        this.setTimer(KeyEnum.KV_TIMER, time, key_b);
                        ++i;
                    }
                    finally {
                        this.lock.unlock(lockEntity);
                    }
                }
                this.commit();
            }
            finally {
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, byte[] value, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            LockEntity lockEntity = this.lock.lock(key);
            try {
                this.start();
                byte[] key_b = ArrayKits.addAll(HEAD_B, keyb);
                this.putDB(key_b, value, SstColumnFamily.DEFAULT);
                int time = (int)(System.currentTimeMillis() / 1000L) + ttl;
                this.putDB(ArrayKits.addAll(HEAD_TTL, keyb), ArrayKits.intToBytes(time), SstColumnFamily.DEFAULT);
                this.setTimer(KeyEnum.KV_TIMER, time, key_b);
                this.commit();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ttl(String key, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            LockEntity lockEntity = this.lock.lock(key);
            try {
                this.start();
                byte[] key_b = ArrayKits.addAll(HEAD_B, keyb);
                int time = (int)(System.currentTimeMillis() / 1000L) + ttl;
                this.putDB(ArrayKits.addAll(HEAD_TTL, keyb), ArrayKits.intToBytes(time), SstColumnFamily.DEFAULT);
                this.setTimer(KeyEnum.KV_TIMER, time, key_b);
                this.commit();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public Map<String, byte[]> get(List<String> keys) throws KitDBException {
        HashMap<String, byte[]> map = null;
        try (CloseLock ignored = this.checkClose();){
            DAssert.notEmpty(keys, ErrorType.EMPTY, "keys is empty");
            byte[][] keybs = new byte[keys.size()][];
            for (int i = 0; i < keys.size(); ++i) {
                keybs[i] = this.getKey(keys.get(i));
            }
            ArrayList<byte[]> vKeys = new ArrayList<byte[]>(keybs.length);
            for (byte[] key : keybs) {
                vKeys.add(ArrayKits.addAll(HEAD_TTL, key));
                vKeys.add(ArrayKits.addAll(HEAD_B, key));
            }
            vKeys.addAll(vKeys);
            Map<String, byte[]> resMap = this.transMap(this.multiGet(vKeys, SstColumnFamily.DEFAULT));
            map = new HashMap<String, byte[]>(keybs.length);
            for (byte[] key : keybs) {
                byte[] ttl_bs = resMap.get(new String(ArrayKits.addAll(HEAD_TTL, key)));
                if (ttl_bs == null) {
                    map.put(new String(key, charset), resMap.get(new String(ArrayKits.addAll(HEAD_B, key))));
                    continue;
                }
                int time = ArrayKits.bytesToInt(ttl_bs, 0);
                if (System.currentTimeMillis() / 1000L - (long)time <= 0L) {
                    map.put(new String(key, charset), null);
                    continue;
                }
                map.put(new String(key, charset), resMap.get(new String(ArrayKits.addAll(HEAD_B, key))));
            }
        }
        return map;
    }

    private Map<String, byte[]> transMap(Map<byte[], byte[]> bsMap) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(bsMap.size());
        for (Map.Entry<byte[], byte[]> entry : bsMap.entrySet()) {
            map.put(new String(entry.getKey()), entry.getValue());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delCheckTTL(String key, int ztime) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock.lock(key);
            try {
                byte[] keyb = this.getKey(key);
                ArrayList<byte[]> keys = new ArrayList<byte[]>();
                keys.add(ArrayKits.addAll(HEAD_TTL, keyb));
                keys.add(ArrayKits.addAll(HEAD_B, keyb));
                Map<String, byte[]> resMap = this.transMap(this.multiGet(keys, SstColumnFamily.DEFAULT));
                byte[] ttl_bs = resMap.get(new String(ArrayKits.addAll(HEAD_TTL, keyb)));
                if (ttl_bs == null) {
                    this.checkTxCommit();
                    return;
                }
                int time = ArrayKits.bytesToInt(ttl_bs, 0);
                if (ztime < time) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.deleteDB(ArrayKits.addAll(HEAD_B, keyb), SstColumnFamily.DEFAULT);
                this.deleteDB(ArrayKits.addAll(HEAD_TTL, keyb), SstColumnFamily.DEFAULT);
                this.commitLocal();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
            return;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            this.checkTxRollBack();
            throw e;
        }
    }

    public byte[] get(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            keys.add(ArrayKits.addAll(HEAD_TTL, keyb));
            keys.add(ArrayKits.addAll(HEAD_B, keyb));
            Map<String, byte[]> resMap = this.transMap(this.multiGet(keys, SstColumnFamily.DEFAULT));
            byte[] ttl_bs = resMap.get(new String(ArrayKits.addAll(HEAD_TTL, keyb)));
            if (ttl_bs == null) {
                byte[] byArray = resMap.get(new String(ArrayKits.addAll(HEAD_B, keyb)));
                return byArray;
            }
            int time = ArrayKits.bytesToInt(ttl_bs, 0);
            if (System.currentTimeMillis() / 1000L - (long)time >= 0L) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = resMap.get(new String(ArrayKits.addAll(HEAD_B, keyb)));
            return byArray;
        }
    }

    public byte[] getNoTTL(String key) throws KitDBException {
        byte[] keyb = this.getKey(key);
        return this.getDB(ArrayKits.addAll(HEAD_B, keyb), SstColumnFamily.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            LockEntity lockEntity = this.lock.lock(key);
            try {
                this.start();
                this.deleteDB(ArrayKits.addAll(HEAD_B, keyb), SstColumnFamily.DEFAULT);
                this.deleteDB(ArrayKits.addAll(HEAD_TTL, keyb), SstColumnFamily.DEFAULT);
                this.commit();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delPrefix(String key_) throws KitDBException {
        this.checkTxRange();
        byte[] keyb_ = this.getKey(key_);
        try (CloseLock ignored = this.checkClose();){
            this.start();
            this.deleteHead(ArrayKits.addAll(HEAD_B, keyb_), SstColumnFamily.DEFAULT);
            this.deleteHead(ArrayKits.addAll(HEAD_TTL, keyb_), SstColumnFamily.DEFAULT);
            this.commit();
        }
        finally {
            this.release();
        }
    }

    public List<String> keys(String key_, int start, int limit) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb_ = this.getKey(key_);
            ArrayList<String> list = new ArrayList<String>();
            int index = 0;
            int count = 0;
            try (RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);){
                byte[] head = ArrayKits.addAll(HEAD_B, keyb_);
                iterator.seek(head);
                while (iterator.isValid() && count < limit) {
                    byte[] key = iterator.key();
                    if (!BytesUtil.checkHead(head, key)) {
                        break;
                    }
                    if (index >= start) {
                        list.add(new String(ArrayKits.sub(key, 1, key.length), charset));
                        ++count;
                    }
                    ++index;
                    iterator.next();
                }
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    int getTtl(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] keyb = this.getKey(key);
            byte[] value_bs = this.getDB(ArrayKits.addAll(HEAD_TTL, keyb), SstColumnFamily.DEFAULT);
            if (value_bs != null) {
                int time = ArrayKits.bytesToInt(value_bs, 0);
                int ttl = (int)(System.currentTimeMillis() / 1000L - (long)time);
                if (ttl <= 0) {
                    int n = 0;
                    return n;
                }
                int n = ttl;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delTtl(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock.lock(key);
            try {
                byte[] keyb = this.getKey(key);
                this.start();
                this.deleteDB(ArrayKits.addAll(HEAD_TTL, keyb), SstColumnFamily.DEFAULT);
                this.commit();
            }
            finally {
                this.lock.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    protected TxLock getTxLock(String key) {
        return new TxLock(String.join((CharSequence)":", HEAD, key));
    }

    public static class Entry {
        private String key;
        private byte[] value;

        public String getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RKv.Entry(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }
}

