/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.MetaAbs;
import top.thinkin.lightd.base.MetaDAbs;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.KeyIterator;
import top.thinkin.lightd.db.RCollection;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.db.RIterator;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class RList
extends RCollection {
    private static final Logger log = LoggerFactory.getLogger(RList.class);
    public static final String HEAD = KeyEnum.LIST.getKey();
    public static final byte[] HEAD_VALUE_B = KeyEnum.LIST_VALUE.getBytes();
    public static final byte[] HEAD_B = HEAD.getBytes();

    @Override
    protected TxLock getTxLock(String key) {
        return new TxLock(String.join((CharSequence)":", HEAD, key));
    }

    protected RList(DB db) {
        super(db, false, 128);
    }

    public void add(String key, byte[] v) throws KitDBException {
        this.addMayTTLPrivate(key, v, -1);
    }

    public void addAll(String key, List<byte[]> vs) throws KitDBException {
        this.addAllMayTTLPrivate(key, vs, -1);
    }

    public void addAllMayTTL(String key, List<byte[]> vs, int ttl) throws KitDBException {
        DAssert.isTrue(ttl > 0, ErrorType.PARAM_ERROR, "ttl must greater than 0");
        this.addAllMayTTLPrivate(key, vs, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, long i, byte[] v) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                DAssert.isTrue(i >= metaV.left && i <= metaV.right, ErrorType.EMPTY, "index not exist");
                this.start();
                ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), i);
                ValueKD valueKD = valueK.convertValueBytes();
                this.putDB(valueKD.toBytes(), v, SstColumnFamily.DEFAULT);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public byte[] get(String key, long i) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                byte[] byArray = null;
                return byArray;
            }
            ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), i);
            byte[] byArray = this.getDB(valueK.convertValueBytes().toBytes(), SstColumnFamily.DEFAULT);
            return byArray;
        }
    }

    public List<byte[]> get(String key, List<Long> is) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            ArrayList<byte[]> list = new ArrayList<byte[]>(is.size());
            Object object = is.iterator();
            while (object.hasNext()) {
                long i = object.next();
                ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), i);
                list.add(this.getDB(valueK.convertValueBytes().toBytes(), SstColumnFamily.DEFAULT));
            }
            object = list;
            return object;
        }
    }

    public Long left(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                Long l = null;
                return l;
            }
            Long l = metaV.left;
            return l;
        }
    }

    public Long right(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                Long l = null;
                return l;
            }
            Long l = metaV.right;
            return l;
        }
    }

    @Override
    public int size(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                int n = 0;
                return n;
            }
            int n = metaV.getSize();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFast(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.deleteFast(key_b, metaV);
            }
            finally {
                this.unlock(lockEntity);
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) throws KitDBException {
        this.checkTxRange();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.deleteDB(key_b, SstColumnFamily.META);
                this.delete(key_b, metaV);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public boolean isExist(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
            MetaV metaV = this.addCheck(k_v);
            boolean bl = metaV != null;
            return bl;
        }
    }

    public List<byte[]> range(String key, long start, long end) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                ArrayList<byte[]> arrayList = list;
                return arrayList;
            }
            ValueK valueK_seek = new ValueK(key_b.length, key_b, metaV.getVersion(), start);
            try (RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);){
                ValueKD valueKD = valueK_seek.convertValueBytes();
                byte[] heads = valueKD.toHeadBytes();
                iterator.seek(valueKD.toBytes());
                long index = 0L;
                while (iterator.isValid() && index < end) {
                    byte[] key_bs = iterator.key();
                    if (!BytesUtil.checkHead(heads, key_bs)) {
                        break;
                    }
                    ValueK valueK = ValueKD.build(key_bs).convertValue();
                    index = valueK.getIndex();
                    list.add(iterator.value());
                    iterator.next();
                }
            }
            ArrayList<byte[]> arrayList = list;
            return arrayList;
        }
    }

    public RIterator<RList> iterator(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            RIterator<RList> rIterator;
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                RIterator<RList> rIterator2 = null;
                return rIterator2;
            }
            ValueK valueK_seek = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.left);
            RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);
            ValueKD valueKD = valueK_seek.convertValueBytes();
            iterator.seek(valueKD.toBytes());
            RIterator<RList> rIterator3 = rIterator = new RIterator<RList>(iterator, this, valueKD.toHeadBytes());
            return rIterator3;
        }
    }

    public Entry getEntry(RocksIterator iterator) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            Entry entry;
            byte[] key_bs = iterator.key();
            if (key_bs == null) {
                Entry entry2 = null;
                return entry2;
            }
            ValueK key = ValueKD.build(key_bs).convertValue();
            Entry entry3 = entry = new Entry(key.index, iterator.value());
            return entry3;
        }
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> blpop(String key, int num) throws KitDBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> brpop(String key, int num) throws KitDBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public KeyIterator getKeyIterator() throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            KeyIterator keyIterator = this.getKeyIterator(HEAD_B);
            return keyIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ttl(String key, int ttl) throws KitDBException {
        DAssert.isTrue(ttl > 0, ErrorType.PARAM_ERROR, "ttl must greater than 0");
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                this.start();
                MetaV metaV = this.getMeta(key_b);
                DAssert.notNull(metaV, ErrorType.NOT_EXIST, "The List does not exist.");
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp((int)(System.currentTimeMillis() / 1000L + (long)ttl));
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delTtl(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                this.checkTxCommit();
                return;
            }
            LockEntity lockEntity = this.lock(key);
            try {
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp(-1);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public int getTtl(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                int n = -1;
                return n;
            }
            if (metaV.getTimestamp() == -1) {
                int n = -1;
                return n;
            }
            int n = (int)((long)metaV.getTimestamp() - System.currentTimeMillis() / 1000L);
            return n;
        }
    }

    public void addMayTTL(String key, byte[] v, int ttl) throws KitDBException {
        DAssert.isTrue(ttl > 0, ErrorType.PARAM_ERROR, "ttl must greater than 0");
        this.addMayTTLPrivate(key, v, ttl);
    }

    private void delete(byte[] key_b, MetaV metaV) {
        ValueK valueK_seek = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.left);
        MetaVD metaVD = metaV.convertMetaBytes();
        ValueKD valueKD = valueK_seek.convertValueBytes();
        byte[] heads = valueKD.toHeadBytes();
        this.deleteHead(heads, SstColumnFamily.DEFAULT);
        byte[] key = ArrayKits.addAll("D".getBytes(charset), key_b, metaVD.getVersion());
        this.deleteDB(key, SstColumnFamily.DEFAULT);
    }

    private MetaV addCheck(byte[] k_v) {
        MetaVD metaVD;
        MetaV metaV = null;
        if (k_v != null && (metaV = (metaVD = MetaVD.build(k_v)).convertMeta()).getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    protected byte[] getKey(String key) throws KitDBException {
        DAssert.notNull(key, ErrorType.NULL, "Key is null");
        return ArrayKits.addAll(HEAD_B, key.getBytes(charset));
    }

    protected MetaV getMeta(byte[] key_b) throws KitDBException {
        MetaV metaV = this.getMetaP(key_b);
        if (metaV == null) {
            return null;
        }
        if (metaV.getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    private MetaV getMetaP(byte[] key_b) throws KitDBException {
        byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
        if (k_v == null) {
            return null;
        }
        MetaV metaV = MetaVD.build(k_v).convertMeta();
        return metaV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deleteByClear(byte[] key_b, MetaV metaV) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            this.start();
            this.delete(key_b, metaV);
            this.commitLocal();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTTL(int time, byte[] key_b, byte[] meta_b) throws KitDBException {
        String key = new String(ArrayKits.sub(key_b, 1, key_b.length + 1), charset);
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            MetaV metaV = this.getMetaP(key_b);
            if (time != metaV.timestamp) {
                return;
            }
            this.deleteTTL(key_b, MetaVD.build(meta_b).convertMeta(), metaV.version);
        }
        finally {
            this.unlock(lockEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllMayTTLPrivate(String key, List<byte[]> vs, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                MetaV metaV = this.addCheck(k_v);
                if (metaV != null) {
                    for (byte[] v : vs) {
                        metaV.size = metaV.size + 1;
                        metaV.right = metaV.right + 1L;
                        if (metaV.size == 1) {
                            metaV.left = metaV.right;
                        }
                        ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.right);
                        ValueKD valueKD = valueK.convertValueBytes();
                        this.putDB(valueKD.toBytes(), v, SstColumnFamily.DEFAULT);
                    }
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    if (ttl != -1) {
                        ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                    }
                    metaV = new MetaV(0, 0L, -1L, ttl, this.db.versionSequence().incr());
                    for (byte[] v : vs) {
                        metaV.size = metaV.size + 1;
                        metaV.right = metaV.right + 1L;
                        if (metaV.size == 1) {
                            metaV.left = metaV.right;
                        }
                        ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.right);
                        this.putDB(valueK.convertValueBytes().toBytes(), v, SstColumnFamily.DEFAULT);
                    }
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                    if (ttl != -1) {
                        this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMayTTLPrivate(String key, byte[] v, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                MetaV metaV = this.addCheck(k_v);
                if (metaV != null) {
                    metaV.size = metaV.size + 1;
                    metaV.right = metaV.right + 1L;
                    if (metaV.size == 1) {
                        metaV.left = metaV.right;
                    }
                    ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.right);
                    ValueKD valueKD = valueK.convertValueBytes();
                    this.putDB(valueKD.toBytes(), v, SstColumnFamily.DEFAULT);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    if (ttl != -1) {
                        ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                    }
                    metaV = new MetaV(1, 0L, 0L, ttl, this.db.versionSequence().incr());
                    ValueK valueK = new ValueK(key_b.length, key_b, metaV.getVersion(), metaV.right);
                    this.putDB(valueK.convertValueBytes().toBytes(), v, SstColumnFamily.DEFAULT);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                    if (ttl != -1) {
                        this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (Exception e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public static class ValueKD {
        private byte[] k_size;
        private byte[] key;
        private byte[] version;
        private byte[] index;

        public byte[] toBytes() {
            byte[] key = ArrayKits.addAll(HEAD_VALUE_B, this.k_size, this.key, this.version, this.index);
            return key;
        }

        public long getIndexV() {
            return ArrayKits.bytesToLong(this.index);
        }

        public byte[] toHeadBytes() {
            byte[] key = ArrayKits.addAll(HEAD_VALUE_B, this.k_size, this.key, this.version);
            return key;
        }

        public ValueK convertValue() {
            ValueK valueK = new ValueK();
            valueK.setIndex(ArrayKits.bytesToLong(this.index));
            valueK.setK_size(ArrayKits.bytesToInt(this.k_size, 0));
            valueK.setKey(this.key);
            valueK.setVersion(ArrayKits.bytesToInt(this.version, 0));
            return valueK;
        }

        public static ValueKD build(byte[] bytes) {
            ValueKD valueKD = new ValueKD();
            valueKD.setK_size(ArrayKits.sub(bytes, 1, 5));
            int position = ArrayKits.bytesToInt(valueKD.getK_size(), 0);
            position = 5 + position;
            valueKD.setKey(ArrayKits.sub(bytes, 5, position));
            valueKD.setVersion(ArrayKits.sub(bytes, position, position += 4));
            valueKD.setIndex(ArrayKits.sub(bytes, position, position + 8));
            return valueKD;
        }

        public byte[] getK_size() {
            return this.k_size;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getIndex() {
            return this.index;
        }

        public void setK_size(byte[] k_size) {
            this.k_size = k_size;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setIndex(byte[] index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueKD)) {
                return false;
            }
            ValueKD other = (ValueKD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getK_size(), other.getK_size())) {
                return false;
            }
            if (!Arrays.equals(this.getKey(), other.getKey())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            return Arrays.equals(this.getIndex(), other.getIndex());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueKD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getK_size());
            result = result * 59 + Arrays.hashCode(this.getKey());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getIndex());
            return result;
        }

        public String toString() {
            return "RList.ValueKD(k_size=" + Arrays.toString(this.getK_size()) + ", key=" + Arrays.toString(this.getKey()) + ", version=" + Arrays.toString(this.getVersion()) + ", index=" + Arrays.toString(this.getIndex()) + ")";
        }
    }

    public static class ValueK {
        private int k_size;
        private byte[] key;
        private int version;
        private long index;

        public ValueKD convertValueBytes() {
            ValueKD valueKD = new ValueKD();
            valueKD.setK_size(ArrayKits.intToBytes(this.getK_size()));
            valueKD.setKey(this.getKey());
            valueKD.setVersion(ArrayKits.intToBytes(this.getVersion()));
            valueKD.setIndex(ArrayKits.longToBytes(this.getIndex()));
            return valueKD;
        }

        public int getK_size() {
            return this.k_size;
        }

        public byte[] getKey() {
            return this.key;
        }

        public int getVersion() {
            return this.version;
        }

        public long getIndex() {
            return this.index;
        }

        public void setK_size(int k_size) {
            this.k_size = k_size;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueK)) {
                return false;
            }
            ValueK other = (ValueK)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getK_size() != other.getK_size()) {
                return false;
            }
            if (!Arrays.equals(this.getKey(), other.getKey())) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return this.getIndex() == other.getIndex();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueK;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getK_size();
            result = result * 59 + Arrays.hashCode(this.getKey());
            result = result * 59 + this.getVersion();
            long $index = this.getIndex();
            result = result * 59 + (int)($index >>> 32 ^ $index);
            return result;
        }

        public String toString() {
            return "RList.ValueK(k_size=" + this.getK_size() + ", key=" + Arrays.toString(this.getKey()) + ", version=" + this.getVersion() + ", index=" + this.getIndex() + ")";
        }

        public ValueK(int k_size, byte[] key, int version, long index) {
            this.k_size = k_size;
            this.key = key;
            this.version = version;
            this.index = index;
        }

        public ValueK() {
        }
    }

    public static class MetaVD
    extends MetaDAbs {
        private byte[] size;
        private byte[] left;
        private byte[] right;
        private byte[] timestamp;
        private byte[] version;

        public static MetaVD build(byte[] bytes) {
            MetaVD metaVD = new MetaVD();
            metaVD.setSize(ArrayKits.sub(bytes, 1, 5));
            metaVD.setLeft(ArrayKits.sub(bytes, 5, 13));
            metaVD.setRight(ArrayKits.sub(bytes, 13, 21));
            metaVD.setTimestamp(ArrayKits.sub(bytes, 21, 25));
            metaVD.setVersion(ArrayKits.sub(bytes, 25, 29));
            return metaVD;
        }

        public MetaV convertMeta() {
            MetaV metaV = new MetaV();
            metaV.setSize(ArrayKits.bytesToInt(this.size, 0));
            metaV.setLeft(ArrayKits.bytesToLong(this.left));
            metaV.setRight(ArrayKits.bytesToLong(this.right));
            metaV.setTimestamp(ArrayKits.bytesToInt(this.timestamp, 0));
            metaV.setVersion(ArrayKits.bytesToInt(this.version, 0));
            return metaV;
        }

        public int getVersionValue() {
            return ArrayKits.bytesToInt(this.version, 0);
        }

        @Override
        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_B, this.size, this.left, this.right, this.timestamp, this.version);
            return value;
        }

        public byte[] toBytesHead() {
            byte[] value = ArrayKits.addAll(HEAD_B, ArrayKits.intToBytes(0), ArrayKits.longToBytes(0L), ArrayKits.longToBytes(0L), ArrayKits.intToBytes(0), this.version);
            return value;
        }

        public byte[] getSize() {
            return this.size;
        }

        public byte[] getLeft() {
            return this.left;
        }

        public byte[] getRight() {
            return this.right;
        }

        public byte[] getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] getVersion() {
            return this.version;
        }

        public void setSize(byte[] size) {
            this.size = size;
        }

        public void setLeft(byte[] left) {
            this.left = left;
        }

        public void setRight(byte[] right) {
            this.right = right;
        }

        public void setTimestamp(byte[] timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaVD)) {
                return false;
            }
            MetaVD other = (MetaVD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getSize(), other.getSize())) {
                return false;
            }
            if (!Arrays.equals(this.getLeft(), other.getLeft())) {
                return false;
            }
            if (!Arrays.equals(this.getRight(), other.getRight())) {
                return false;
            }
            if (!Arrays.equals(this.getTimestamp(), other.getTimestamp())) {
                return false;
            }
            return Arrays.equals(this.getVersion(), other.getVersion());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaVD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getSize());
            result = result * 59 + Arrays.hashCode(this.getLeft());
            result = result * 59 + Arrays.hashCode(this.getRight());
            result = result * 59 + Arrays.hashCode(this.getTimestamp());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            return result;
        }

        public String toString() {
            return "RList.MetaVD(size=" + Arrays.toString(this.getSize()) + ", left=" + Arrays.toString(this.getLeft()) + ", right=" + Arrays.toString(this.getRight()) + ", timestamp=" + Arrays.toString(this.getTimestamp()) + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }
    }

    public static class MetaV
    extends MetaAbs {
        private int size;
        private long left;
        private long right;
        private int timestamp;
        private int version;

        public MetaVD convertMetaBytes() {
            MetaVD metaVD = new MetaVD();
            metaVD.setSize(ArrayKits.intToBytes(this.size));
            metaVD.setLeft(ArrayKits.longToBytes(this.left));
            metaVD.setRight(ArrayKits.longToBytes(this.right));
            metaVD.setTimestamp(ArrayKits.intToBytes(this.timestamp));
            metaVD.setVersion(ArrayKits.intToBytes(this.version));
            return metaVD;
        }

        public int getSize() {
            return this.size;
        }

        public long getLeft() {
            return this.left;
        }

        public long getRight() {
            return this.right;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setLeft(long left) {
            this.left = left;
        }

        public void setRight(long right) {
            this.right = right;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaV)) {
                return false;
            }
            MetaV other = (MetaV)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getLeft() != other.getLeft()) {
                return false;
            }
            if (this.getRight() != other.getRight()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            return this.getVersion() == other.getVersion();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaV;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $left = this.getLeft();
            result = result * 59 + (int)($left >>> 32 ^ $left);
            long $right = this.getRight();
            result = result * 59 + (int)($right >>> 32 ^ $right);
            result = result * 59 + this.getTimestamp();
            result = result * 59 + this.getVersion();
            return result;
        }

        public String toString() {
            return "RList.MetaV(size=" + this.getSize() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ")";
        }

        public MetaV(int size, long left, long right, int timestamp, int version) {
            this.size = size;
            this.left = left;
            this.right = right;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaV() {
        }
    }

    public class Entry
    extends REntry {
        private long index;
        private byte[] value;

        public long getIndex() {
            return this.index;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $index = this.getIndex();
            result = result * 59 + (int)($index >>> 32 ^ $index);
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RList.Entry(index=" + this.getIndex() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(long index, byte[] value) {
            this.index = index;
            this.value = value;
        }
    }
}

