/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import org.rocksdb.RocksDBException;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.kit.ArrayKits;

public class Sequence {
    public static final String HEAD = KeyEnum.SEQ.getKey();
    private static final byte[] HEAD_B = HEAD.getBytes();
    private final byte[] key_b;
    private DB db;
    private Long version;

    public synchronized long incr(Long increment) throws RocksDBException {
        if (this.version == null) {
            byte[] value = this.db.rocksDB().get(this.key_b);
            this.version = value == null ? Long.valueOf(0L) : Long.valueOf(ArrayKits.bytesToLong(value));
        }
        this.version = this.version + increment;
        this.db.rocksDB().put(this.key_b, ArrayKits.longToBytes(this.version));
        return this.version;
    }

    public Long get() {
        return this.version;
    }

    public Sequence(DB db, byte[] key) {
        this.db = db;
        this.key_b = ArrayKits.addAll(HEAD_B, key);
    }
}

