/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.kit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import top.thinkin.lightd.kit.StringKits;

public class FileZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(ZipOutputStream zipOutputStream, File file, String parentFileName) {
        FileInputStream in = null;
        try {
            int len;
            ZipEntry zipEntry = new ZipEntry(parentFileName + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            in = new FileInputStream(file);
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) != -1) {
                zipOutputStream.write(buf, 0, len);
            }
            zipOutputStream.closeEntry();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void directory(ZipOutputStream zipOutputStream, File file, String parentFileName) {
        File[] files = file.listFiles();
        String parentFileNameTemp = null;
        for (File fileTemp : files) {
            String string = parentFileNameTemp = StringKits.isEmpty(parentFileName) ? fileTemp.getName() : parentFileName + "/" + fileTemp.getName();
            if (fileTemp.isDirectory()) {
                FileZipUtils.directory(zipOutputStream, fileTemp, parentFileNameTemp);
                continue;
            }
            FileZipUtils.zipFile(zipOutputStream, fileTemp, parentFileNameTemp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(String source, String destit) {
        File file = new File(source);
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(destit);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            if (file.isDirectory()) {
                FileZipUtils.directory(zipOutputStream, file, "");
            } else {
                FileZipUtils.zipFile(zipOutputStream, file, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean delFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileZipUtils.delFile(f);
            }
        }
        return file.delete();
    }
}

