/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.kit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void compressDirectoryToZipFile(String rootDir, String sourceDir, ZipOutputStream zos) throws IOException {
        File[] files;
        String dir = Paths.get(rootDir, sourceDir).toString();
        for (File file : files = ZipUtil.requireNonNull(new File(dir).listFiles(), "files")) {
            if (file.isDirectory()) {
                ZipUtil.compressDirectoryToZipFile(rootDir, Paths.get(sourceDir, file.getName()).toString(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(Paths.get(sourceDir, file.getName()).toString()));
            try (FileInputStream in = new FileInputStream(Paths.get(rootDir, sourceDir, file.getName()).toString());){
                ZipUtil.copy(in, zos);
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = ZipUtil.copyLarge(input, output);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return ZipUtil.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        boolean var5 = false;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static void unzipFile(String sourceFile, String outputDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(sourceFile));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                File entryFile = new File(outputDir + File.separator + fileName);
                ZipUtil.forceMkdir(entryFile.getParentFile());
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    ZipUtil.copy(zis, fos);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                String message = "File " + directory + " exists and is not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!directory.mkdirs() && !directory.isDirectory()) {
            String message = "Unable to create directory " + directory;
            throw new IOException(message);
        }
    }

    private ZipUtil() {
    }
}

