/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.util.concurrent.locks.ReentrantLock;
import top.thinkin.lightd.base.KeyLock;

public class LockEntity {
    final ReentrantLock reentrantLock = new ReentrantLock();
    private volatile int time;
    private final String key;
    private volatile int lockSize = 0;
    private KeyLock keyLock;

    public LockEntity(String key, KeyLock keyLock) {
        this.key = key;
        this.keyLock = keyLock;
    }

    public void lock() {
        this.reentrantLock.lock();
    }

    public void unlock() {
        this.reentrantLock.unlock();
    }

    public void setTime() {
        this.time = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getTime() {
        return this.time;
    }

    public void unlockSelf() {
        this.keyLock.unlock(this);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized void addSize() {
        ++this.lockSize;
    }

    public synchronized void subSize() {
        --this.lockSize;
    }

    public synchronized int getLockSize() {
        return this.lockSize;
    }

    public KeyLock getKeyLock() {
        return this.keyLock;
    }

    public void setKeyLock(KeyLock keyLock) {
        this.keyLock = keyLock;
    }
}

