/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class SegmentLock {
    private final List<ReentrantLock> buckets = new ArrayList<ReentrantLock>();
    private final int size;

    public SegmentLock(int size) {
        this.size = size;
        for (int i = 0; i < this.size; ++i) {
            this.buckets.add(new ReentrantLock(true));
        }
    }

    public void lock(byte[] key) {
        int h = this.hash(this.hashCode(key));
        ReentrantLock lock = this.buckets.get(h);
        lock.lock();
    }

    public void unlock(byte[] key) {
        int h = this.hash(this.hashCode(key));
        ReentrantLock lock = this.buckets.get(h);
        lock.unlock();
    }

    private int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return this.size - 1 & n;
    }

    private int hashCode(byte[] value) {
        int h = 0;
        byte[] val = value;
        for (int i = 0; i < value.length; ++i) {
            h = 31 * h + val[i];
        }
        return h;
    }
}

