/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.MergeOperator;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;

public class TableConfig {
    private static BlockBasedTableConfig createTableConfig() {
        return new BlockBasedTableConfig().setBlockSize(4096L).setFilter((Filter)new BloomFilter(16, false)).setCacheIndexAndFilterBlocks(true).setBlockCacheSize(0x8000000L).setCacheNumShardBits(8);
    }

    private static BlockBasedTableConfig createDefTableConfig() {
        return new BlockBasedTableConfig().setBlockSize(4096L).setFilter((Filter)new BloomFilter(16, false));
    }

    public static ColumnFamilyOptions createColumnFamilyOptions() {
        BlockBasedTableConfig tConfig = TableConfig.createTableConfig();
        ColumnFamilyOptions opts = TableConfig.getDefaultRocksDBColumnFamilyOptions();
        opts.setTableFormatConfig((TableFormatConfig)tConfig).setMergeOperator((MergeOperator)new StringAppendOperator());
        return opts;
    }

    public static ColumnFamilyOptions createDefColumnFamilyOptions() {
        BlockBasedTableConfig tConfig = TableConfig.createDefTableConfig();
        ColumnFamilyOptions opts = TableConfig.getDefaultRocksDBColumnFamilyOptions();
        opts.setTableFormatConfig((TableFormatConfig)tConfig).setMergeOperator((MergeOperator)new StringAppendOperator());
        return opts;
    }

    public static ColumnFamilyOptions getDefaultRocksDBColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(3);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(10);
        opts.setLevel0SlowdownWritesTrigger(20);
        opts.setLevel0StopWritesTrigger(40);
        opts.setMaxBytesForLevelBase(0x20000000L);
        opts.setTargetFileSizeBase(0x4000000L);
        opts.setMemtablePrefixBloomSizeRatio(0.125);
        opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        return opts;
    }
}

