/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rocksdb.Transaction;
import top.thinkin.lightd.base.LockEntity;

public class TransactionEntity
implements Serializable {
    private static final Logger log = LogManager.getLogger(TransactionEntity.class);
    private int count = 0;
    private String uuid;
    private transient Transaction transaction;
    private transient List<LockEntity> locks = new ArrayList<LockEntity>();

    public TransactionEntity() {
        this.uuid = UUID.randomUUID().toString();
    }

    public int addCount() {
        return this.count++;
    }

    public int subCount() {
        return this.count--;
    }

    public void reset() {
        this.count = 0;
        for (LockEntity lock : this.locks) {
            lock.unlockSelf();
        }
        this.locks.clear();
        this.transaction = null;
    }

    public void addLock(LockEntity lockEntity) {
        this.locks.add(lockEntity);
    }

    public int getCount() {
        return this.count;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public String getUuid() {
        return this.uuid;
    }
}

