/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.MetaAbs;
import top.thinkin.lightd.base.MetaDAbs;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.KeyIterator;
import top.thinkin.lightd.db.RCollection;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.db.RIterator;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;

public class RMap
extends RCollection {
    private static final Logger log = LoggerFactory.getLogger(RMap.class);
    protected static final String HEAD = KeyEnum.MAP.getKey();
    public static byte[] HEAD_B = HEAD.getBytes();
    public static final byte[] HEAD_KEY_B = KeyEnum.MAP_KEY.getBytes();

    @Override
    protected TxLock getTxLock(String key) {
        return new TxLock(String.join((CharSequence)":", HEAD, key));
    }

    protected RMap(DB db) {
        super(db, false, 128);
    }

    protected byte[] getKey(String key) throws KitDBException {
        DAssert.notNull(key, ErrorType.NULL, "Key is null");
        return ArrayKits.addAll(HEAD_B, key.getBytes(charset));
    }

    private Meta addCheck(byte[] key_b, byte[] k_v) {
        MetaD metaVD;
        Meta metaV = null;
        if (k_v != null && (metaV = (metaVD = MetaD.build(k_v)).convertMeta()).getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    private void setEntry(byte[] key_b, Meta metaV, Entry[] entrys) {
        for (Entry entry : entrys) {
            metaV.size = metaV.size + 1;
            Key key = new Key(key_b.length, key_b, metaV.getVersion(), entry.key.getBytes(charset));
            this.putDB(key.convertBytes().toBytes(), entry.value, SstColumnFamily.DEFAULT);
        }
    }

    public void put(String key, String mkey, byte[] value) throws KitDBException {
        this.putTTL(key, mkey, value, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTTL(String key, String mkey, byte[] value, int ttl) throws KitDBException {
        byte[] mkey_b = mkey.getBytes(charset);
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                Meta metaV = this.addCheck(key_b, k_v);
                if (ttl != -1) {
                    ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                }
                if (metaV != null) {
                    if (ttl != -1) {
                        this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                    metaV.size = metaV.size + 1;
                    metaV.setTimestamp(ttl);
                    Key key_ = new Key(key_b.length, key_b, metaV.getVersion(), mkey_b);
                    this.putDB(key_.convertBytes().toBytes(), value, SstColumnFamily.DEFAULT);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    metaV = new Meta(0, ttl, this.db.versionSequence().incr());
                    metaV.size = metaV.size + 1;
                    Key key_ = new Key(key_b.length, key_b, metaV.getVersion(), mkey_b);
                    this.putDB(key_.convertBytes().toBytes(), value, SstColumnFamily.DEFAULT);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                }
                if (metaV.getTimestamp() != -1) {
                    this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public void put(String key, Map<String, byte[]> map) throws KitDBException {
        this.putMayTTL(key, -1, map);
    }

    public void putMayTTL(String key, int ttl, Map<String, byte[]> map) throws KitDBException {
        DAssert.notEmpty(map, ErrorType.EMPTY, "entries is empty");
        Entry[] entries = new Entry[map.keySet().size()];
        int j = 0;
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            entries[j] = new Entry(entry.getKey(), entry.getValue());
            ++j;
        }
        this.putMayTTL(key, ttl, entries);
    }

    public void putMayTTL(String key, int ttl, String mkey, byte[] value) throws KitDBException {
        this.putMayTTL(key, ttl, new Entry(mkey, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMayTTL(String key, int ttl, Entry ... entries) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            DAssert.notEmpty(entries, ErrorType.EMPTY, "entries is empty");
            byte[][] bytess = new byte[entries.length][];
            for (int i = 0; i < entries.length; ++i) {
                bytess[i] = entries[i].value;
            }
            DAssert.isTrue(ArrayKits.noRepeate(bytess), ErrorType.REPEATED_KEY, "Repeated keys");
            LockEntity lockEntity = this.lock(key);
            try {
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                Meta metaV = this.addCheck(key_b, k_v);
                if (ttl != -1) {
                    ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                }
                if (metaV != null) {
                    this.setEntry(key_b, metaV, entries);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    metaV = new Meta(0, ttl, this.db.versionSequence().incr());
                    metaV.setTimestamp(ttl);
                    this.setEntry(key_b, metaV, entries);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                    if (metaV.getTimestamp() != -1) {
                        this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public Map<String, byte[]> get(String key, String ... keys) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            DAssert.notEmpty(keys, ErrorType.EMPTY, "keys is empty");
            Meta metaV = this.getMeta(key_b);
            if (metaV == null) {
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                return hashMap;
            }
            HashMap<String, byte[]> map = new HashMap<String, byte[]>(keys.length);
            ArrayList<byte[]> keyList = new ArrayList<byte[]>();
            for (String mkey : keys) {
                byte[] mkey_b = mkey.getBytes(charset);
                Key vkey = new Key(key_b.length, key_b, metaV.getVersion(), mkey_b);
                keyList.add(vkey.convertBytes().toBytes());
            }
            Map<byte[], byte[]> resMap = this.multiGet(keyList, SstColumnFamily.DEFAULT);
            for (Map.Entry<byte[], byte[]> entry : resMap.entrySet()) {
                byte[] resKey = entry.getKey();
                KeyD keyd = KeyD.build(resKey);
                map.put(new String(keyd.convertValue().getKey()), entry.getValue());
            }
            HashMap<String, byte[]> hashMap = map;
            return hashMap;
        }
    }

    public byte[] get(String key, String mkey) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] value;
            byte[] mkey_b = mkey.getBytes(charset);
            byte[] key_b = this.getKey(key);
            Meta metaV = this.getMeta(key_b);
            if (metaV == null) {
                byte[] byArray = null;
                return byArray;
            }
            Key vkey = new Key(key_b.length, key_b, metaV.getVersion(), mkey_b);
            byte[] byArray = value = this.getDB(vkey.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
            return byArray;
        }
    }

    private Meta getMetaP(byte[] key_b) throws KitDBException {
        byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
        if (k_v == null) {
            return null;
        }
        Meta metaV = MetaD.build(k_v).convertMeta();
        return metaV;
    }

    protected Meta getMeta(byte[] key_b) throws KitDBException {
        Meta metaV = this.getMetaP(key_b);
        if (metaV == null) {
            return null;
        }
        if (metaV.getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, String ... keys) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            DAssert.notEmpty(keys, ErrorType.EMPTY, "keys is empty");
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                Meta metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                for (String mkey : keys) {
                    byte[] mkey_b = mkey.getBytes(charset);
                    Key vkey = new Key(key_b.length, key_b, metaV.getVersion(), mkey_b);
                    byte[] value = this.getDB(vkey.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
                    if (value == null) continue;
                    this.deleteDB(vkey.convertBytes().toBytes(), SstColumnFamily.DEFAULT);
                    metaV.size = metaV.size - 1;
                }
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    private void delete(byte[] key_b, Meta meta) {
        MetaD metaD = meta.convertMetaBytes();
        Key vkey = new Key(key_b.length, key_b, meta.getVersion(), null);
        this.deleteHead(vkey.getHead(), SstColumnFamily.DEFAULT);
        this.deleteDB(ArrayKits.addAll("D".getBytes(charset), key_b, metaD.getVersion()), SstColumnFamily.DEFAULT);
    }

    protected synchronized void deleteByClear(byte[] key_b, Meta meta) throws KitDBException {
        try {
            this.start();
            this.delete(key_b, meta);
            this.commitLocal();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) throws KitDBException {
        this.checkTxRange();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                Meta meta = this.getMeta(key_b);
                if (meta == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.deleteDB(key_b, SstColumnFamily.META);
                this.delete(key_b, meta);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public KeyIterator getKeyIterator() throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            KeyIterator keyIterator = this.getKeyIterator(HEAD_B);
            return keyIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTTL(int time, byte[] key_b, byte[] meta_b) throws KitDBException {
        String key = new String(ArrayKits.sub(key_b, 1, key_b.length + 1), charset);
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            Meta meta = this.getMetaP(key_b);
            if (meta == null || time != meta.timestamp) {
                return;
            }
            this.deleteTTL(key_b, MetaD.build(meta_b).convertMeta(), meta.version);
        }
        finally {
            this.unlock(lockEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFast(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            LockEntity lockEntity = this.lock(key);
            try {
                byte[] key_b = this.getKey(key);
                Meta metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.deleteFast(key_b, metaV);
            }
            finally {
                this.unlock(lockEntity);
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public RIterator<RMap> iterator(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            RIterator<RMap> rIterator;
            byte[] key_b = this.getKey(key);
            Meta metaV = this.getMeta(key_b);
            if (metaV == null) {
                RIterator<RMap> rIterator2 = null;
                return rIterator2;
            }
            Key k_seek = new Key(key_b.length, key_b, metaV.getVersion(), null);
            RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);
            iterator.seek(k_seek.getHead());
            RIterator<RMap> rIterator3 = rIterator = new RIterator<RMap>(iterator, this, k_seek.getHead());
            return rIterator3;
        }
    }

    public Entry getEntry(RocksIterator iterator) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            Entry entry;
            byte[] key_bs = iterator.key();
            if (key_bs == null) {
                Entry entry2 = null;
                return entry2;
            }
            KeyD keyD = KeyD.build(key_bs);
            Entry entry3 = entry = new Entry(new String(keyD.key, charset), iterator.value());
            return entry3;
        }
    }

    @Override
    public int getTtl(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            Meta meta = this.getMeta(key_b);
            if (meta == null) {
                int n = -1;
                return n;
            }
            if (meta.getTimestamp() == -1) {
                int n = -1;
                return n;
            }
            int n = (int)((long)meta.getTimestamp() - System.currentTimeMillis() / 1000L);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delTtl(String key) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                Meta metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp(-1);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ttl(String key, int ttl) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                Meta metaV = this.getMeta(key_b);
                if (metaV == null) {
                    metaV = new Meta(0, -1, this.db.versionSequence().incr());
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp((int)(System.currentTimeMillis() / 1000L + (long)ttl));
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public boolean isExist(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
            Meta meta = this.addCheck(key_b, k_v);
            boolean bl = meta != null;
            return bl;
        }
    }

    @Override
    public int size(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            Meta metaV = this.getMeta(key_b);
            if (metaV == null) {
                int n = 0;
                return n;
            }
            int n = metaV.getSize();
            return n;
        }
    }

    public static class KeyD {
        private byte[] mapKeySize;
        private byte[] mapKey;
        private byte[] version;
        private byte[] key;

        public static KeyD build(byte[] bytes) {
            KeyD keyD = new KeyD();
            keyD.setMapKeySize(ArrayKits.sub(bytes, 1, 5));
            int position = ArrayKits.bytesToInt(keyD.getMapKeySize(), 0);
            position = 5 + position;
            keyD.setMapKey(ArrayKits.sub(bytes, 5, position));
            keyD.setVersion(ArrayKits.sub(bytes, position, position += 4));
            keyD.setKey(ArrayKits.sub(bytes, position, bytes.length));
            return keyD;
        }

        public byte[] toBytes() {
            return ArrayKits.addAll(HEAD_KEY_B, this.mapKeySize, this.mapKey, this.version, this.key);
        }

        public Key convertValue() {
            Key key = new Key();
            key.setMapKeySize(ArrayKits.bytesToInt(this.mapKeySize, 0));
            key.setMapKey(this.mapKey);
            key.setVersion(ArrayKits.bytesToInt(this.version, 0));
            key.setKey(this.key);
            return key;
        }

        public byte[] getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setMapKeySize(byte[] mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyD)) {
                return false;
            }
            KeyD other = (KeyD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getMapKeySize(), other.getMapKeySize())) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            return Arrays.equals(this.getKey(), other.getKey());
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getMapKeySize());
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getKey());
            return result;
        }

        public String toString() {
            return "RMap.KeyD(mapKeySize=" + Arrays.toString(this.getMapKeySize()) + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + Arrays.toString(this.getVersion()) + ", key=" + Arrays.toString(this.getKey()) + ")";
        }
    }

    public static class Key {
        private int mapKeySize;
        private byte[] mapKey;
        private int version;
        private byte[] key;

        public KeyD convertBytes() {
            KeyD keyD = new KeyD();
            keyD.setMapKeySize(ArrayKits.intToBytes(this.mapKeySize));
            keyD.setMapKey(this.mapKey);
            keyD.setVersion(ArrayKits.intToBytes(this.version));
            keyD.setKey(this.key);
            return keyD;
        }

        public byte[] getHead() {
            byte[] value = ArrayKits.addAll(HEAD_KEY_B, ArrayKits.intToBytes(this.mapKeySize), this.mapKey, ArrayKits.intToBytes(this.version));
            return value;
        }

        public int getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setMapKeySize(int mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMapKeySize() != other.getMapKeySize()) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return Arrays.equals(this.getKey(), other.getKey());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMapKeySize();
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + this.getVersion();
            result = result * 59 + Arrays.hashCode(this.getKey());
            return result;
        }

        public String toString() {
            return "RMap.Key(mapKeySize=" + this.getMapKeySize() + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + this.getVersion() + ", key=" + Arrays.toString(this.getKey()) + ")";
        }

        public Key(int mapKeySize, byte[] mapKey, int version, byte[] key) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.key = key;
        }

        public Key() {
        }
    }

    public static class MetaD
    extends MetaDAbs {
        private byte[] size;
        private byte[] timestamp;
        private byte[] version;

        public byte[] toBytesHead() {
            byte[] value = ArrayKits.addAll(HEAD_B, ArrayKits.intToBytes(0), ArrayKits.intToBytes(0), this.version);
            return value;
        }

        public static MetaD build(byte[] bytes) {
            MetaD metaD = new MetaD();
            metaD.setSize(ArrayKits.sub(bytes, 1, 5));
            metaD.setTimestamp(ArrayKits.sub(bytes, 5, 9));
            metaD.setVersion(ArrayKits.sub(bytes, 9, 13));
            return metaD;
        }

        @Override
        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_B, this.size, this.timestamp, this.version);
            return value;
        }

        public Meta convertMeta() {
            Meta meta = new Meta();
            meta.setSize(ArrayKits.bytesToInt(this.size, 0));
            meta.setTimestamp(ArrayKits.bytesToInt(this.timestamp, 0));
            meta.setVersion(ArrayKits.bytesToInt(this.version, 0));
            return meta;
        }

        public byte[] getSize() {
            return this.size;
        }

        public byte[] getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] getVersion() {
            return this.version;
        }

        public void setSize(byte[] size) {
            this.size = size;
        }

        public void setTimestamp(byte[] timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaD)) {
                return false;
            }
            MetaD other = (MetaD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getSize(), other.getSize())) {
                return false;
            }
            if (!Arrays.equals(this.getTimestamp(), other.getTimestamp())) {
                return false;
            }
            return Arrays.equals(this.getVersion(), other.getVersion());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getSize());
            result = result * 59 + Arrays.hashCode(this.getTimestamp());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            return result;
        }

        public String toString() {
            return "RMap.MetaD(size=" + Arrays.toString(this.getSize()) + ", timestamp=" + Arrays.toString(this.getTimestamp()) + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }

        public MetaD(byte[] size, byte[] timestamp, byte[] version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaD() {
        }
    }

    public static class Meta
    extends MetaAbs {
        private int size;
        private int timestamp;
        private int version;

        public MetaD convertMetaBytes() {
            MetaD metaVD = new MetaD();
            metaVD.setSize(ArrayKits.intToBytes(this.size));
            metaVD.setTimestamp(ArrayKits.intToBytes(this.timestamp));
            metaVD.setVersion(ArrayKits.intToBytes(this.version));
            return metaVD;
        }

        public int getSize() {
            return this.size;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            return this.getVersion() == other.getVersion();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + this.getTimestamp();
            result = result * 59 + this.getVersion();
            return result;
        }

        public String toString() {
            return "RMap.Meta(size=" + this.getSize() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ")";
        }

        public Meta(int size, int timestamp, int version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public Meta() {
        }
    }

    public static class Entry
    extends REntry {
        private String key;
        private byte[] value;

        public String getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RMap.Entry(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }
}

