/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rocksdb.RocksIterator;
import top.thinkin.lightd.base.CloseLock;
import top.thinkin.lightd.base.LockEntity;
import top.thinkin.lightd.base.MetaAbs;
import top.thinkin.lightd.base.MetaDAbs;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.base.TxLock;
import top.thinkin.lightd.data.KeyEnum;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.KeyIterator;
import top.thinkin.lightd.db.RCollection;
import top.thinkin.lightd.db.REntry;
import top.thinkin.lightd.db.RIterator;
import top.thinkin.lightd.exception.DAssert;
import top.thinkin.lightd.exception.ErrorType;
import top.thinkin.lightd.exception.KitDBException;
import top.thinkin.lightd.kit.ArrayKits;

public class RSet
extends RCollection {
    public static final String HEAD = KeyEnum.SET.getKey();
    public static final byte[] HEAD_B = HEAD.getBytes();
    public static final byte[] HEAD_V_B = KeyEnum.SET_V.getBytes();

    @Override
    protected TxLock getTxLock(String key) {
        return new TxLock(String.join((CharSequence)":", HEAD, key));
    }

    protected RSet(DB db) {
        super(db, false, 128);
    }

    protected byte[] getKey(String key) throws KitDBException {
        DAssert.notNull(key, ErrorType.NULL, "Key is null");
        return ArrayKits.addAll(HEAD_B, key.getBytes(charset));
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> pop(String key, int num) throws KitDBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 36[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void remove(String key, byte[] ... values) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            MetaV metaV;
            byte[] key_b;
            LockEntity lockEntity;
            block21: {
                DAssert.notEmpty((Object[])values, ErrorType.EMPTY, "values is empty");
                lockEntity = this.lock(key);
                key_b = this.getKey(key);
                metaV = this.getMeta(key_b);
                if (metaV != null) break block21;
                this.checkTxCommit();
                return;
            }
            try {
                ArrayList<byte[]> dels = new ArrayList<byte[]>();
                for (byte[] v : values) {
                    SData sData = new SData(key_b.length, key_b, metaV.getVersion(), v);
                    SDataD sDataD = sData.convertBytes();
                    byte[] scoreD = this.getDB(sDataD.toBytes(), SstColumnFamily.DEFAULT);
                    if (scoreD == null) continue;
                    dels.add(sDataD.toBytes());
                }
                this.start();
                this.removeDo(metaV, dels);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            catch (Exception e) {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public boolean contains(String key, byte[] value) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                boolean bl = false;
                return bl;
            }
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), value);
            boolean bl = this.getDB(sData.convertBytes().toBytes(), SstColumnFamily.DEFAULT) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMayTTL(String key, int ttl, byte[] ... values) throws KitDBException {
        this.checkTxStart();
        try (CloseLock ignored = this.checkClose();){
            DAssert.notEmpty((Object[])values, ErrorType.EMPTY, "values is empty");
            DAssert.isTrue(ArrayKits.noRepeate(values), ErrorType.REPEATED_KEY, "Repeated memebers");
            byte[] key_b = this.getKey(key);
            LockEntity lockEntity = this.lock(key);
            try {
                this.start();
                byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
                MetaV metaV = this.addCheck(key_b, k_v);
                if (metaV != null) {
                    this.setEntry(key_b, metaV, values);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                } else {
                    if (ttl != -1) {
                        ttl = (int)(System.currentTimeMillis() / 1000L + (long)ttl);
                    }
                    metaV = new MetaV(0, ttl, this.db.versionSequence().incr());
                    this.setEntry(key_b, metaV, values);
                    this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                    if (metaV.getTimestamp() != -1) {
                        this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                    }
                }
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public void add(String key, byte[] ... values) throws KitDBException {
        this.addMayTTL(key, -1, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deleteByClear(byte[] key_b, MetaD meta) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            this.start();
            this.delete(key_b, meta);
            this.commitLocal();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTTL(int time, byte[] key_b, byte[] meta_b) throws KitDBException {
        String key = new String(ArrayKits.sub(key_b, 1, key_b.length + 1), charset);
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            MetaV metaV = this.getMetaP(key_b);
            if (metaV == null || time != metaV.timestamp) {
                return;
            }
            MetaV metaV1 = MetaD.build(meta_b).convertMetaV();
            this.deleteTTL(key_b, metaV1, metaV.version);
        }
        finally {
            this.unlock(lockEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) throws KitDBException {
        this.checkTxRange();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            try {
                this.start();
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.deleteDB(key_b, SstColumnFamily.META);
                this.delete(key_b, metaV.convertMetaBytes());
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public KeyIterator getKeyIterator() throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            KeyIterator keyIterator = this.getKeyIterator(HEAD_B);
            return keyIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFast(String key) throws KitDBException {
        this.checkTxStart();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
            if (k_v == null) {
                this.checkTxCommit();
                return;
            }
            MetaV meta = MetaD.build(k_v).convertMetaV();
            try {
                this.deleteFast(key_b, meta);
            }
            finally {
                this.unlock(lockEntity);
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    public RIterator<RSet> iterator(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                RIterator<RSet> rIterator = null;
                return rIterator;
            }
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), "".getBytes());
            RocksIterator iterator = this.newIterator(SstColumnFamily.DEFAULT);
            iterator.seek(sData.getHead());
            RIterator<RSet> rIterator = new RIterator<RSet>(iterator, this, sData.getHead());
            return rIterator;
        }
    }

    @Override
    public int getTtl(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            if (metaV == null) {
                int n = -1;
                return n;
            }
            if (metaV.getTimestamp() == -1) {
                int n = -1;
                return n;
            }
            int n = (int)((long)metaV.getTimestamp() - System.currentTimeMillis() / 1000L);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delTtl(String key) throws KitDBException {
        this.checkTxStart();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            try {
                byte[] key_b = this.getKey(key);
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp(-1);
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ttl(String key, int ttl) throws KitDBException {
        this.checkTxStart();
        LockEntity lockEntity = this.lock(key);
        try (CloseLock ignored = this.checkClose();){
            try {
                byte[] key_b = this.getKey(key);
                MetaV metaV = this.getMeta(key_b);
                if (metaV == null) {
                    this.checkTxCommit();
                    return;
                }
                this.start();
                this.delTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                metaV.setTimestamp((int)(System.currentTimeMillis() / 1000L + (long)ttl));
                this.putDB(key_b, metaV.convertMetaBytes().toBytes(), SstColumnFamily.META);
                this.setTimerCollection(KeyEnum.COLLECT_TIMER, metaV.getTimestamp(), key_b, metaV.convertMetaBytes().toBytesHead());
                this.commit();
            }
            finally {
                this.unlock(lockEntity);
                this.release();
            }
            this.checkTxCommit();
        }
        catch (KitDBException e) {
            this.checkTxRollBack();
            throw e;
        }
    }

    @Override
    public boolean isExist(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            boolean bl = metaV != null;
            return bl;
        }
    }

    @Override
    public int size(String key) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            byte[] key_b = this.getKey(key);
            MetaV metaV = this.getMeta(key_b);
            int n = metaV.getSize();
            return n;
        }
    }

    public Entry getEntry(RocksIterator iterator) throws KitDBException {
        try (CloseLock ignored = this.checkClose();){
            Entry entry;
            byte[] key_bs = iterator.key();
            if (key_bs == null) {
                Entry entry2 = null;
                return entry2;
            }
            SData sData = SDataD.build(key_bs).convertValue();
            Entry entry3 = entry = new Entry(sData.value);
            return entry3;
        }
    }

    private MetaV addCheck(byte[] key_b, byte[] k_v) {
        MetaV metaV = null;
        if (k_v != null) {
            MetaD metaD = MetaD.build(k_v);
            metaV = metaD.convertMetaV();
            long nowTime = System.currentTimeMillis() / 1000L;
            if (metaV.getTimestamp() != -1 && nowTime > (long)metaV.getTimestamp()) {
                metaV = null;
            }
        }
        return metaV;
    }

    private void removeDo(MetaV metaV, List<byte[]> dels) {
        for (byte[] del : dels) {
            metaV.setSize(metaV.getSize() - 1);
            this.deleteDB(del, SstColumnFamily.DEFAULT);
        }
    }

    private void setEntry(byte[] key_b, MetaV metaV, byte[][] values) throws KitDBException {
        for (byte[] value : values) {
            SData sData = new SData(key_b.length, key_b, metaV.getVersion(), value);
            byte[] member = sData.convertBytes().toBytes();
            if (this.getDB(member, SstColumnFamily.DEFAULT) == null) {
                metaV.size = metaV.size + 1;
            }
            this.putDB(sData.convertBytes().toBytes(), "".getBytes(), SstColumnFamily.DEFAULT);
        }
    }

    private void delete(byte[] key_b, MetaD metaD) {
        MetaV metaV = metaD.convertMetaV();
        SData sData = new SData(key_b.length, key_b, metaV.getVersion(), null);
        this.deleteHead(sData.getHead(), SstColumnFamily.DEFAULT);
        this.deleteDB(ArrayKits.addAll("D".getBytes(charset), key_b, metaD.getVersion()), SstColumnFamily.DEFAULT);
    }

    private MetaV getMetaP(byte[] key_b) throws KitDBException {
        byte[] k_v = this.getDB(key_b, SstColumnFamily.META);
        if (k_v == null) {
            return null;
        }
        MetaV metaV = MetaD.build(k_v).convertMetaV();
        return metaV;
    }

    protected MetaV getMeta(byte[] key_b) throws KitDBException {
        MetaV metaV = this.getMetaP(key_b);
        if (metaV == null) {
            return null;
        }
        if (metaV.getTimestamp() != -1 && System.currentTimeMillis() / 1000L - (long)metaV.getTimestamp() >= 0L) {
            metaV = null;
        }
        return metaV;
    }

    public static class SDataD {
        private byte[] mapKeySize;
        private byte[] mapKey;
        private byte[] version;
        private byte[] value;

        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_V_B, this.mapKeySize, this.mapKey, this.version, this.value);
            return value;
        }

        public static SDataD build(byte[] bytes) {
            SDataD sDataD = new SDataD();
            sDataD.setMapKeySize(ArrayKits.sub(bytes, 1, 5));
            int position = ArrayKits.bytesToInt(sDataD.getMapKeySize(), 0);
            position = 5 + position;
            sDataD.setMapKey(ArrayKits.sub(bytes, 5, position));
            sDataD.setVersion(ArrayKits.sub(bytes, position, position += 4));
            sDataD.setValue(ArrayKits.sub(bytes, position, bytes.length));
            return sDataD;
        }

        public SData convertValue() {
            SData sData = new SData();
            sData.setMapKeySize(ArrayKits.bytesToInt(this.mapKeySize, 0));
            sData.setMapKey(this.mapKey);
            sData.setVersion(ArrayKits.bytesToInt(this.version, 0));
            sData.setValue(this.value);
            return sData;
        }

        public byte[] getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(byte[] mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SDataD)) {
                return false;
            }
            SDataD other = (SDataD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getMapKeySize(), other.getMapKeySize())) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SDataD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getMapKeySize());
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RSet.SDataD(mapKeySize=" + Arrays.toString(this.getMapKeySize()) + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + Arrays.toString(this.getVersion()) + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public SDataD(byte[] mapKeySize, byte[] mapKey, byte[] version, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.value = value;
        }

        public SDataD() {
        }
    }

    public static class SData {
        private int mapKeySize;
        private byte[] mapKey;
        private int version;
        private byte[] value;

        public SDataD convertBytes() {
            SDataD sDataD = new SDataD();
            sDataD.setMapKeySize(ArrayKits.intToBytes(this.mapKeySize));
            sDataD.setMapKey(this.mapKey);
            sDataD.setVersion(ArrayKits.intToBytes(this.version));
            sDataD.setValue(this.value);
            return sDataD;
        }

        public byte[] getHead() {
            byte[] value = ArrayKits.addAll(HEAD_V_B, ArrayKits.intToBytes(this.mapKeySize), this.mapKey, ArrayKits.intToBytes(this.version));
            return value;
        }

        public int getMapKeySize() {
            return this.mapKeySize;
        }

        public byte[] getMapKey() {
            return this.mapKey;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setMapKeySize(int mapKeySize) {
            this.mapKeySize = mapKeySize;
        }

        public void setMapKey(byte[] mapKey) {
            this.mapKey = mapKey;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SData)) {
                return false;
            }
            SData other = (SData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMapKeySize() != other.getMapKeySize()) {
                return false;
            }
            if (!Arrays.equals(this.getMapKey(), other.getMapKey())) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMapKeySize();
            result = result * 59 + Arrays.hashCode(this.getMapKey());
            result = result * 59 + this.getVersion();
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RSet.SData(mapKeySize=" + this.getMapKeySize() + ", mapKey=" + Arrays.toString(this.getMapKey()) + ", version=" + this.getVersion() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }

        public SData(int mapKeySize, byte[] mapKey, int version, byte[] value) {
            this.mapKeySize = mapKeySize;
            this.mapKey = mapKey;
            this.version = version;
            this.value = value;
        }

        public SData() {
        }
    }

    public static class MetaD
    extends MetaDAbs {
        private byte[] size;
        private byte[] timestamp;
        private byte[] version;

        public static MetaD build(byte[] bytes) {
            MetaD metaD = new MetaD();
            metaD.setSize(ArrayKits.sub(bytes, 1, 5));
            metaD.setTimestamp(ArrayKits.sub(bytes, 5, 9));
            metaD.setVersion(ArrayKits.sub(bytes, 9, 13));
            return metaD;
        }

        public byte[] toBytesHead() {
            byte[] value = ArrayKits.addAll(HEAD_B, ArrayKits.intToBytes(0), ArrayKits.intToBytes(0), this.version);
            return value;
        }

        @Override
        public byte[] toBytes() {
            byte[] value = ArrayKits.addAll(HEAD_B, this.size, this.timestamp, this.version);
            return value;
        }

        public MetaV convertMetaV() {
            MetaV metaV = new MetaV();
            metaV.setSize(ArrayKits.bytesToInt(this.size, 0));
            metaV.setTimestamp(ArrayKits.bytesToInt(this.timestamp, 0));
            metaV.setVersion(ArrayKits.bytesToInt(this.version, 0));
            return metaV;
        }

        public byte[] getSize() {
            return this.size;
        }

        public byte[] getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] getVersion() {
            return this.version;
        }

        public void setSize(byte[] size) {
            this.size = size;
        }

        public void setTimestamp(byte[] timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaD)) {
                return false;
            }
            MetaD other = (MetaD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getSize(), other.getSize())) {
                return false;
            }
            if (!Arrays.equals(this.getTimestamp(), other.getTimestamp())) {
                return false;
            }
            return Arrays.equals(this.getVersion(), other.getVersion());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getSize());
            result = result * 59 + Arrays.hashCode(this.getTimestamp());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            return result;
        }

        public String toString() {
            return "RSet.MetaD(size=" + Arrays.toString(this.getSize()) + ", timestamp=" + Arrays.toString(this.getTimestamp()) + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }

        public MetaD(byte[] size, byte[] timestamp, byte[] version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaD() {
        }
    }

    public static class MetaV
    extends MetaAbs {
        private int size;
        private int timestamp;
        private int version;

        public MetaD convertMetaBytes() {
            MetaD metaVD = new MetaD();
            metaVD.setSize(ArrayKits.intToBytes(this.size));
            metaVD.setTimestamp(ArrayKits.intToBytes(this.timestamp));
            metaVD.setVersion(ArrayKits.intToBytes(this.version));
            return metaVD;
        }

        public int getSize() {
            return this.size;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaV)) {
                return false;
            }
            MetaV other = (MetaV)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            return this.getVersion() == other.getVersion();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaV;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + this.getTimestamp();
            result = result * 59 + this.getVersion();
            return result;
        }

        public String toString() {
            return "RSet.MetaV(size=" + this.getSize() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ")";
        }

        public MetaV(int size, int timestamp, int version) {
            this.size = size;
            this.timestamp = timestamp;
            this.version = version;
        }

        public MetaV() {
        }
    }

    public static class Entry
    extends REntry {
        private byte[] value;

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "RSet.Entry(value=" + Arrays.toString(this.getValue()) + ")";
        }

        public Entry(byte[] value) {
            this.value = value;
        }
    }
}

