/*
 * Decompiled with CFR 0.152.
 */
package top.thinkin.lightd.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import top.thinkin.lightd.base.SstColumnFamily;
import top.thinkin.lightd.db.DB;
import top.thinkin.lightd.db.RBase;
import top.thinkin.lightd.kit.ArrayKits;
import top.thinkin.lightd.kit.BytesUtil;

public class TimerStore {
    public static byte[] DEF = "".getBytes();

    private static byte[] getHead(String headStr) {
        return headStr.getBytes();
    }

    public static void put(RBase rBase, String head, int time, byte[] value) {
        rBase.putDB(ArrayKits.addAll(TimerStore.getHead(head), ArrayKits.intToBytes(time), value), DEF, SstColumnFamily.DEFAULT);
    }

    public static void del(RBase rBase, String head, int time, byte[] value) {
        rBase.deleteDB(ArrayKits.addAll(TimerStore.getHead(head), ArrayKits.intToBytes(time), value), SstColumnFamily.DEFAULT);
    }

    public static List<TData> rangeDel(DB db, String head, int start, int end, int limit, Function function) throws Exception {
        ArrayList<TData> entries = new ArrayList<TData>();
        ArrayList<byte[]> dels = new ArrayList<byte[]>();
        try (RocksIterator iterator = db.newIterator(SstColumnFamily.DEFAULT);){
            iterator.seek(ArrayKits.addAll(TimerStore.getHead(head), ArrayKits.intToBytes(start)));
            long index = 0L;
            for (int count = 0; iterator.isValid() && index <= (long)end && count < limit; ++count) {
                byte[] key_bs = iterator.key();
                if (!BytesUtil.checkHead(TimerStore.getHead(head), key_bs)) {
                    break;
                }
                TData tData = new TData();
                tData.setTime(ArrayKits.bytesToInt(ArrayKits.sub(key_bs, 3, 7), 0));
                tData.setValue(ArrayKits.sub(key_bs, 7, key_bs.length));
                index = tData.getTime();
                if (index > (long)end) {
                    break;
                }
                entries.add(tData);
                dels.add(key_bs);
                iterator.next();
            }
        }
        function.call(entries);
        if (dels.size() == 0) {
            return entries;
        }
        var9_10 = null;
        try (WriteBatch batch = new WriteBatch();){
            for (byte[] del : dels) {
                batch.delete(db.defHandle, del);
            }
            db.rocksDB().write(db.writeOptions, batch);
        }
        catch (Throwable throwable) {
            var9_10 = throwable;
            throw throwable;
        }
        return entries;
    }

    public static List<TData> rangeDel(DB db, String head, int start, int end, int limit) throws RocksDBException {
        ArrayList<TData> entries = new ArrayList<TData>();
        ArrayList<byte[]> dels = new ArrayList<byte[]>();
        try (RocksIterator iterator = db.newIterator(SstColumnFamily.DEFAULT);){
            iterator.seek(ArrayKits.addAll(TimerStore.getHead(head), ArrayKits.intToBytes(start)));
            long index = 0L;
            for (int count = 0; iterator.isValid() && index <= (long)end && count < limit; ++count) {
                byte[] key_bs = iterator.key();
                if (!BytesUtil.checkHead(TimerStore.getHead(head), key_bs)) {
                    break;
                }
                TData tData = new TData();
                tData.setTime(ArrayKits.bytesToInt(ArrayKits.sub(key_bs, 3, 7), 0));
                tData.setValue(ArrayKits.sub(key_bs, 7, key_bs.length));
                index = tData.getTime();
                if (index > (long)end) {
                    break;
                }
                entries.add(tData);
                dels.add(key_bs);
                iterator.next();
            }
        }
        if (dels.size() == 0) {
            return entries;
        }
        var8_9 = null;
        try (WriteBatch batch = new WriteBatch();){
            for (byte[] del : dels) {
                batch.delete(db.defHandle, del);
            }
            db.rocksDB().write(db.writeOptions, batch);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        return entries;
    }

    public static class TData {
        private int time;
        private byte[] value;

        public int getTime() {
            return this.time;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TData)) {
                return false;
            }
            TData other = (TData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof TData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTime();
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "TimerStore.TData(time=" + this.getTime() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    public static interface Function {
        public void call(List<TData> var1) throws Exception;
    }
}

