/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.base;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import top.verytouch.vkit.common.base.ApiCode;
import top.verytouch.vkit.common.exception.AssertException;
import top.verytouch.vkit.common.util.StringUtils;

public final class Assert {
    public static void require(boolean condition, String message) {
        if (!condition) {
            throw new AssertException(message);
        }
    }

    public static <T> void require(T target, Predicate<T> predicate, String message) {
        Assert.require(predicate.test(target), message);
    }

    public static void require(boolean condition, ApiCode apiCode) {
        if (!condition) {
            throw new AssertException(apiCode);
        }
    }

    public static String require(String target, String regex, String message) {
        Assert.require(Pattern.matches(regex, target), message);
        return target;
    }

    public static void nonNull(Object target, String message) {
        Assert.require(target != null, message);
    }

    public static void nonEmpty(Object target, String message) {
        Assert.require(target != null, message);
        if (target instanceof Iterable) {
            Assert.require(((Iterable)target).iterator().hasNext(), message);
        } else if (target instanceof Object[]) {
            Assert.require(((Object[])target).length > 0, message);
        } else if (target instanceof Map) {
            Assert.require(((Map)target).size() > 0, message);
        } else {
            Assert.require(target.toString().length() > 0, message);
        }
    }

    public static void nonBlank(String string, String message) {
        Assert.require(string, org.apache.commons.lang3.StringUtils::isNotBlank, message);
    }

    public static String trimmedNonBlank(String string, String message) {
        Assert.require(string, org.apache.commons.lang3.StringUtils::isNotBlank, message);
        return string.trim();
    }

    public static void length(String string, int min, int max, String message) {
        int len = StringUtils.length((CharSequence)string);
        Assert.require(len >= min && len <= max, message);
    }

    public static void oneOf(Object target, String message, Object ... objs) {
        for (Object obj : objs) {
            if (!Objects.equals(target, obj)) continue;
            return;
        }
        throw new AssertException(message);
    }

    public static void equals(Object o1, Object o2, String message) {
        Assert.require(o1 != null && o1.equals(o2), message);
    }

    public static void equalsIgnoreCase(String s1, String s2, String message) {
        Assert.require(s1 != null && s1.equalsIgnoreCase(s2), message);
    }

    public static <T> T instanceOf(Object target, Class<T> clazz, String message) {
        Assert.require(target != null && clazz.isAssignableFrom(target.getClass()), message);
        return (T)target;
    }
}

