/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.function.BiFunction;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class CryptUtils {
    public static final String MODE_ECB = "ECB";
    public static final String MODE_CBC = "CBC";
    public static final String MODE_OFB = "OFB";
    public static final String MODE_CFB = "CFB";
    public static final String MODE_CTR = "CTR";
    public static final String PADDING_PKCS5 = "PKCS5Padding";
    public static final String PADDING_NO_PADDING = "NoPadding";

    private CryptUtils() {
    }

    public static byte[] encrypt(String data, String algorithm, Key key, byte[] iv, int blockSize) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        if (iv != null) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, key, ivParameterSpec);
        } else {
            cipher.init(1, key);
        }
        if (blockSize == -1) {
            return cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        return CryptUtils.doFinalByBlock(cipher, data.getBytes(StandardCharsets.UTF_8), blockSize);
    }

    public static byte[] encrypt(String data, Key key) throws Exception {
        return CryptUtils.encrypt(data, key.getAlgorithm(), key, null, -1);
    }

    public static String decrypt(byte[] data, String algorithm, Key key, byte[] iv, int blockSize) throws Exception {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            cipher = new NullCipher();
        }
        if (iv != null) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, key, ivParameterSpec);
        } else {
            cipher.init(2, key);
        }
        if (blockSize == -1) {
            return new String(cipher.doFinal(data));
        }
        return new String(CryptUtils.doFinalByBlock(cipher, data, blockSize));
    }

    public static String decrypt(byte[] data, Key key) throws Exception {
        return CryptUtils.decrypt(data, key.getAlgorithm(), key, null, -1);
    }

    private static byte[] doFinalByBlock(Cipher cipher, byte[] data, int blockSize) throws Exception {
        int dataLen = data.length;
        int blockCount = (int)Math.ceil((double)dataLen * 1.0 / (double)blockSize);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (int i = 0; i < blockCount; ++i) {
                int offset = i * blockSize;
                int len = Math.min(dataLen - offset, blockSize);
                byte[] cache = cipher.doFinal(data, offset, len);
                out.write(cache, 0, cache.length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static byte[] sign(String data, String algorithm, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(privateKey);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return signature.sign();
    }

    public static boolean verify(String data, String algorithm, PublicKey publicKey, byte[] sign) throws Exception {
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(publicKey);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return signature.verify(sign);
    }

    public static byte[] digest(String data, String algorithm) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return digest.digest();
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte datum : data) {
            String hex = Integer.toHexString(datum & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hexStr) {
        if (hexStr.length() < 1) {
            return new byte[0];
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static enum Algorithm {
        DES(1, "DES", "\u5bc6\u94a5\u957f\u5ea656\uff0c\u52a08\u6821\u9a8c\u4f4d"),
        TRIPLE_DES(1, "DESede", "\u5bc6\u94a5\u957f\u5ea6112, 168\uff0c\u52a0\u5bc6\u65b9\u5f0f\uff1aDES\u52a0\u5bc6\u4e00\u6b21\uff0c\u89e3\u5bc6\u4e00\u6b21\uff0c\u518d\u52a0\u5bc6\u4e00\u6b21"),
        AES(1, "AES", "\u5bc6\u94a5\u957f\u5ea6128, 192, 256"),
        RC4(1, "RC4", "\u5bc6\u94a5\u957f\u5ea640-1024"),
        BLOWFISH(1, "Blowfish", "\u5bc6\u94a5\u957f\u5ea632-448\uff0c\u4e14\u5fc5\u987b\u662f8\u7684\u500d\u6570"),
        RSA(2, "RSA", "\u5bc6\u94a5\u957f\u5ea6512, 1024, 2048, 3072\uff0c4096....\u5e94\u8be5\u516c\u94a5\u52a0\u5bc6\u79c1\u94a5\u89e3\u5bc6"),
        MD5(3, "MD5", ""),
        SHA1(3, "SHA-1", ""),
        SHA256(3, "SHA-256", ""),
        DSA(4, "DSA", "\u5bc6\u94a5\u957f\u5ea6\u53c2\u8003RSA\uff0c\u53ea\u7528\u4f5c\u7b7e\u540d\uff0c\u5e94\u8be5\u79c1\u94a5\u7b7e\u540d\u516c\u94a5\u9a8c\u8bc1"),
        MD5_RSA(4, "SHA1withRSA", ""),
        SHA1_RSA(4, "MD5withRSA", "");

        private final int type;
        private final String algorithm;
        private final String remark;

        private Algorithm(int type, String algorithm, String remark) {
            this.type = type;
            this.algorithm = algorithm;
            this.remark = remark;
        }

        public int getType() {
            return this.type;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getRemark() {
            return this.remark;
        }
    }

    public static final class DSA {
        private static final int KEY_SIZE = 1024;

        private DSA() {
        }

        public static KeyPair keyPair() throws Exception {
            return KeyGen.keyPair("DSA", 1024);
        }

        public static String privateSignHex(String data, byte[] key) throws Exception {
            PrivateKey privateKey = KeyGen.privateKey("DSA", key);
            return CryptUtils.toHex(CryptUtils.sign(data, "DSA", privateKey));
        }

        public static boolean publicVerifyHex(String data, byte[] key, String sign) throws Exception {
            PublicKey publicKey = KeyGen.publicKey("DSA", key);
            return CryptUtils.verify(data, "DSA", publicKey, CryptUtils.fromHex(sign));
        }
    }

    public static final class RSA {
        private static final int ENCRYPT_BLOCK_SIZE = 117;
        private static final int DECRYPT_BLOCK_SIZE = 128;
        private static final int KEY_SIZE = 1024;

        private RSA() {
        }

        public static KeyPair keyPair() throws Exception {
            return KeyGen.keyPair("RSA", 1024);
        }

        public static PublicKey publicKeyFromPrivateKey(RSAPrivateCrtKey privateKey) throws Exception {
            KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm());
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(privateKey.getModulus(), privateKey.getPublicExponent());
            return keyFactory.generatePublic(rsaPublicKeySpec);
        }

        public static String publicEncryptHex(String data, byte[] key) throws Exception {
            PublicKey publicKey = KeyGen.publicKey("RSA", key);
            return CryptUtils.toHex(CryptUtils.encrypt(data, "RSA", publicKey, null, 117));
        }

        public static String privateDecryptFromHex(String data, byte[] key) throws Exception {
            PrivateKey privateKey = KeyGen.privateKey("RSA", key);
            return CryptUtils.decrypt(CryptUtils.fromHex(data), "RSA", privateKey, null, 128);
        }
    }

    public static final class AES {
        private static final String ALG = "AES/CBC/PKCS5Padding";
        private static final byte[] IV = new byte[16];
        private static final int KEY_SIZE = 128;

        private AES() {
        }

        public static byte[] secretKey() throws Exception {
            return KeyGen.secretKey("AES", 128).getEncoded();
        }

        public static String encryptHex(String data, byte[] key) throws Exception {
            SecretKey secretKey = KeyGen.secretKey("AES", key);
            return CryptUtils.toHex(CryptUtils.encrypt(data, ALG, secretKey, IV, -1));
        }

        public static String decryptHex(String data, byte[] key) throws Exception {
            SecretKey secretKey = KeyGen.secretKey("AES", key);
            return CryptUtils.decrypt(CryptUtils.fromHex(data), ALG, secretKey, IV, -1);
        }
    }

    public static final class KeyGen {
        public static final String[] PKCS8_PUBLIC = new String[]{"-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----"};
        public static final String[] PKCS8_PRIVATE = new String[]{"-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"};

        private KeyGen() {
        }

        public static SecretKey secretKey(String algorithm, int keySize) throws Exception {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(keySize);
            return keyGenerator.generateKey();
        }

        public static SecretKey secretKey(String algorithm, byte[] key) {
            return new SecretKeySpec(key, algorithm);
        }

        public static KeyPair keyPair(String algorithm, int keySize) throws Exception {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator.generateKeyPair();
        }

        public static void keyPairPKCS8(String algorithm, int keySize, Path pub, Path pri) throws Exception {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            BiFunction<byte[], String[], String> pkcs8Fun = (data, prefixSuffix) -> {
                String s = Base64.getEncoder().encodeToString((byte[])data).replaceAll("(.{64})", "$1\n");
                return String.format("%s\n%s\n%s", prefixSuffix[0], s, prefixSuffix[1]);
            };
            Files.write(pub, pkcs8Fun.apply(keyPair.getPublic().getEncoded(), PKCS8_PUBLIC).getBytes(), new OpenOption[0]);
            Files.write(pri, pkcs8Fun.apply(keyPair.getPrivate().getEncoded(), PKCS8_PRIVATE).getBytes(), new OpenOption[0]);
        }

        public static PublicKey publicKey(String algorithm, byte[] key) throws Exception {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            return keyFactory.generatePublic(keySpec);
        }

        public static PrivateKey privateKey(String algorithm, byte[] key) throws Exception {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            return keyFactory.generatePrivate(keySpec);
        }

        public static PublicKey publicKeyFromPKCS8(String algorithm, String pkcs8) throws Exception {
            String base64 = pkcs8.replace(PKCS8_PUBLIC[0], "").replace(PKCS8_PUBLIC[1], "").replaceAll("[\r\n]", "");
            return KeyGen.publicKey(algorithm, Base64.getDecoder().decode(base64));
        }

        public static PrivateKey privateKeyFromPKCS8(String algorithm, String pkcs8) throws Exception {
            String base64 = pkcs8.replace(PKCS8_PRIVATE[0], "").replace(PKCS8_PRIVATE[1], "").replaceAll("[\r\n]", "");
            return KeyGen.privateKey(algorithm, Base64.getDecoder().decode(base64));
        }
    }
}

