/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import top.verytouch.vkit.common.base.Assert;

public class HttpUtils {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_FORM = "application/x-www-url-form-encoded";
    private String url;
    private String method = "GET";
    private Map<String, String> headers;
    private Map<String, Object> params;
    private byte[] body;
    private Charset charset = StandardCharsets.UTF_8;
    private int connectTimeout = 3000;
    private int readTimeout = 10000;
    private boolean followRedirects = false;
    private boolean useCaches = false;
    private boolean encodeParam = true;

    public HttpUtils(String url) {
        Assert.nonNull(url, "url cannot be null or empty");
        this.url = url;
    }

    public static String get(String url) throws Exception {
        return new HttpUtils(url).get();
    }

    public static String get(String url, Map<String, Object> params) throws Exception {
        return new HttpUtils(url).params(params).get();
    }

    public static String post(String url, Map<String, Object> params) throws Exception {
        return new HttpUtils(url).params(params).post();
    }

    public static String postJson(String url, String json) throws Exception {
        return new HttpUtils(url).addHeader("Content-Type", APPLICATION_JSON).body(json.getBytes(StandardCharsets.UTF_8)).post();
    }

    public static byte[] download(String url) throws Exception {
        return new HttpUtils(url).request().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response request() throws Exception {
        if (this.params != null && this.params.size() > 0) {
            this.url = this.url + "?" + this.params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(this.body != null);
            connection.setUseCaches(this.useCaches);
            connection.setInstanceFollowRedirects(this.followRedirects);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setRequestMethod(this.method);
            if (this.headers != null && this.headers.size() > 0) {
                for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                    connection.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            connection.connect();
            if (this.body != null) {
                try (OutputStream out = connection.getOutputStream();){
                    IOUtils.copy((InputStream)new ByteArrayInputStream(this.body), (OutputStream)out);
                }
            }
            Assert.require(connection.getResponseCode() == 200, String.format("request failed: code=%s, message=%s", connection.getResponseCode(), connection.getResponseMessage()));
            Response response = new Response(IOUtils.toByteArray((InputStream)connection.getInputStream()), connection.getHeaderFields());
            return response;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public String get() throws Exception {
        return this.method("GET").request().getString();
    }

    public String post() throws Exception {
        return this.method("POST").request().getString();
    }

    public HttpUtils method(String method) {
        this.method = method;
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpUtils addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpUtils params(Map<String, Object> params) {
        this.params = params;
        if (this.encodeParam && this.params != null) {
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                entry.setValue(this.urlEncode(entry.getValue().toString()));
            }
        }
        return this;
    }

    public HttpUtils addParam(String key, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, this.encodeParam ? this.urlEncode(value) : value);
        return this;
    }

    public HttpUtils charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public HttpUtils encodeParam(boolean encodeParam) {
        this.encodeParam = encodeParam;
        return this;
    }

    public HttpUtils body(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpUtils readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpUtils connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpUtils useCaches(boolean useCaches) {
        this.useCaches = useCaches;
        return this;
    }

    public HttpUtils followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public boolean isEncodeParam() {
        return this.encodeParam;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public void setEncodeParam(boolean encodeParam) {
        this.encodeParam = encodeParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpUtils)) {
            return false;
        }
        HttpUtils other = (HttpUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.isFollowRedirects() != other.isFollowRedirects()) {
            return false;
        }
        if (this.isUseCaches() != other.isUseCaches()) {
            return false;
        }
        return this.isEncodeParam() == other.isEncodeParam();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + (this.isFollowRedirects() ? 79 : 97);
        result = result * 59 + (this.isUseCaches() ? 79 : 97);
        result = result * 59 + (this.isEncodeParam() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "HttpUtils(url=" + this.getUrl() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ", body=" + Arrays.toString(this.getBody()) + ", charset=" + this.getCharset() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", followRedirects=" + this.isFollowRedirects() + ", useCaches=" + this.isUseCaches() + ", encodeParam=" + this.isEncodeParam() + ")";
    }

    public static class Response {
        private final byte[] bytes;
        private final Map<String, String> headers;

        public Response(byte[] bytes, Map<String, List<String>> headers) {
            this.bytes = bytes;
            this.headers = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty() ? (String)((List)entry.getValue()).get(0) : ""));
        }

        public String getString() {
            return new String(this.bytes);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getBytes(), other.getBytes())) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getBytes());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "HttpUtils.Response(bytes=" + Arrays.toString(this.getBytes()) + ", headers=" + this.getHeaders() + ")";
        }
    }
}

