/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.verytouch.vkit.common.exception.BusinessException;

public final class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object bean) {
        try {
            return mapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            throw new BusinessException("json\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    public static JsonNode toTree(Object value) {
        return mapper.valueToTree(value);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new BusinessException("json\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    public static Map<String, Object> mapFromJson(String json) {
        try {
            return (Map)mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (IOException e) {
            throw new BusinessException("json\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    public static <T> List<T> listFromJson(String json, Class<T> clazz) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            throw new BusinessException("json\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    static {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

