/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;

public class RandomUtils {
    public static final String BASE_CHAR_CODE = "123456789abcdefghijklmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String BASE_CHAR_NUM = "1234567890";

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String character(String base, int length) {
        Objects.requireNonNull(base, "base can not be null");
        StringBuilder stringBuffer = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(base.charAt(random.nextInt(base.length())));
        }
        return stringBuffer.toString();
    }

    public static String number(int length) {
        return RandomUtils.character(BASE_CHAR_NUM, length);
    }

    public static String captcha(OutputStream os) throws IOException {
        BufferedImage image = new BufferedImage(200, 70, 1);
        String str = RandomUtils.captcha(200, 70, image, BASE_CHAR_CODE, 4);
        ImageIO.write((RenderedImage)image, "png", os);
        os.flush();
        os.close();
        return str;
    }

    public static String captcha(int width, int height, BufferedImage img, String base, int length) {
        int i;
        char[] chars;
        Graphics2D graphics = (Graphics2D)img.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        graphics.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 40));
        StringBuilder sb = new StringBuilder();
        int x = 10;
        String ch = "";
        Random random = new Random();
        for (char aChar : chars = RandomUtils.character(base, length).toCharArray()) {
            graphics.setColor(RandomUtils.color());
            int degree = random.nextInt() % 30;
            ch = String.valueOf(aChar);
            sb.append(ch);
            graphics.rotate((double)degree * Math.PI / 180.0, x, 45.0);
            graphics.drawString(ch, x, 45);
            graphics.rotate((double)(-degree) * Math.PI / 180.0, x, 45.0);
            x += 48;
        }
        for (i = 0; i < 6; ++i) {
            graphics.setColor(RandomUtils.color());
            graphics.drawLine(random.nextInt(width), random.nextInt(height), random.nextInt(width), random.nextInt(height));
        }
        for (i = 0; i < 30; ++i) {
            int x1 = random.nextInt(width);
            int y1 = random.nextInt(height);
            graphics.setColor(RandomUtils.color());
            graphics.fillRect(x1, y1, 2, 2);
        }
        return sb.toString();
    }

    public static Color color() {
        Random ran = new Random();
        return new Color(ran.nextInt(256), ran.nextInt(256), ran.nextInt(256));
    }
}

