/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class TreeUtils {
    public static List<? extends TreeAble> listToTree(List<? extends TreeAble> list, Object rootId) {
        LinkedList<TreeAble> tree = new LinkedList<TreeAble>();
        if (list == null || list.isEmpty() || rootId == null) {
            return tree;
        }
        Iterator<? extends TreeAble> iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeAble item = iterator.next();
            if (!rootId.equals(item.pid())) continue;
            tree.add(item);
            iterator.remove();
        }
        for (TreeAble node : tree) {
            node.children(TreeUtils.listToTree(list, node.id()));
        }
        return tree;
    }

    public static List<? extends TreeAble> treeToList(List<? extends TreeAble> tree) {
        LinkedList<? extends TreeAble> list = new LinkedList<TreeAble>();
        if (tree == null || tree.isEmpty()) {
            return list;
        }
        for (TreeAble treeAble : tree) {
            list.add(treeAble);
            if (treeAble.children() != null) {
                list.addAll(TreeUtils.treeToList(treeAble.children()));
            }
            treeAble.children(null);
        }
        return list;
    }

    public static TreeAble getChildTree(List<? extends TreeAble> tree, Object id) {
        if (tree == null || tree.isEmpty()) {
            return null;
        }
        for (TreeAble treeAble : tree) {
            if (Objects.equals(treeAble.id(), id)) {
                return treeAble;
            }
            TreeAble childTree = TreeUtils.getChildTree(treeAble.children(), id);
            if (childTree == null) continue;
            return childTree;
        }
        return null;
    }

    public static interface TreeAble {
        public Object id();

        public Object pid();

        public List<? extends TreeAble> children();

        public void children(List<? extends TreeAble> var1);
    }
}

