/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import top.verytouch.vkit.common.base.Assert;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static boolean isMail(String mail) {
        return Pattern.matches(".+@.+\\..+", mail);
    }

    public static boolean isTel(String tel) {
        return Pattern.matches("^1\\d{10}$", tel);
    }

    public static boolean isIdNo(String idNo) {
        return Pattern.matches("^\\d{6}\\d{4}[01]\\d[0123]\\d\\d{3}[\\dXx]$", idNo);
    }

    public static String genderFromIdNo(String idNo) {
        Assert.require(StringUtils.isIdNo(idNo), "\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        int remainder = Integer.parseInt(idNo.substring(16, 17)) % 2;
        return remainder == 1 ? "M" : "F";
    }

    public static String birthdayFromIdNo(String idNo) {
        Assert.require(StringUtils.isIdNo(idNo), "\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        String year = idNo.substring(6, 10);
        String month = idNo.substring(10, 12);
        String day = idNo.substring(12, 14);
        return String.format("%s-%s-%s", year, month, day);
    }

    public static String camelToUnderScore(String camel) {
        return Optional.ofNullable(camel).orElse("").replaceAll("([A-Z])", "_$1").toLowerCase();
    }

    public static String underScoreToCamel(String underScore) {
        String[] array = Optional.ofNullable(underScore).orElse("").split("_");
        return array[0] + Stream.of(array).skip(1L).map(v -> StringUtils.isEmpty((CharSequence)v) ? "" : Character.toUpperCase(v.charAt(0)) + v.substring(1)).reduce((a, b) -> a + b).orElse("");
    }
}

