/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.base;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<T> {
    private final Map<String, CacheValue<T>> store = new ConcurrentHashMap<String, CacheValue<T>>();

    public void put(String key, T data, Duration duration) {
        this.clean();
        this.store.put(key, new CacheValue<T>(data, LocalDateTime.now().plusSeconds(duration.getSeconds())));
    }

    public void put(String key, T data) {
        this.clean();
        this.store.put(key, new CacheValue<T>(data, null));
    }

    public T get(String key) {
        this.clean();
        CacheValue<T> value = this.store.get(key);
        return value == null || value.isExpired() ? null : (T)value.data;
    }

    public T getOrDefault(String key, T defaultVal) {
        this.clean();
        CacheValue<T> value = this.store.get(key);
        return value == null || value.isExpired() ? defaultVal : value.data;
    }

    public T remove(String key) {
        this.clean();
        CacheValue<T> value = this.store.remove(key);
        return value == null || value.isExpired() ? null : (T)value.data;
    }

    public boolean containsKey(String key) {
        this.clean();
        return this.store.containsKey(key);
    }

    public void clean() {
        this.store.entrySet().removeIf(entry -> ((CacheValue)entry.getValue()).isExpired());
    }

    private static class CacheValue<T> {
        T data;
        LocalDateTime expireAt;

        public CacheValue(T data, LocalDateTime expireAt) {
            this.data = data;
            this.expireAt = expireAt;
        }

        public boolean isExpired() {
            return this.expireAt != null && LocalDateTime.now().isAfter(this.expireAt);
        }
    }
}

