/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.base;

import java.util.Map;
import top.verytouch.vkit.common.base.ApiCode;

public class Response<T> {
    private int code;
    private T data;
    private String msg;
    private String traceId;
    private Map<String, Object> extra;

    public static <T> Response<T> of(int code, T data, String msg, Map<String, Object> extra) {
        Response<T> res = new Response<T>();
        res.setCode(code);
        res.setData(data);
        res.setMsg(msg);
        res.setExtra(extra);
        return res;
    }

    public static Response<String> of(ApiCode apiCode) {
        return Response.of(apiCode.getCode(), null, apiCode.getDesc(), null);
    }

    public static <T> Response<T> ok(T data) {
        return Response.of(ApiCode.OK.getCode(), data, ApiCode.OK.getDesc(), null);
    }

    public static <T> Response<T> ok(T data, Map<String, Object> extra) {
        return Response.of(ApiCode.OK.getCode(), data, ApiCode.OK.getDesc(), extra);
    }

    public static <T> Response<T> ok(T data, String msg) {
        return Response.of(ApiCode.OK.getCode(), data, msg, null);
    }

    public static <T> Response<T> ok() {
        return Response.of(ApiCode.OK.getCode(), null, ApiCode.OK.getDesc(), null);
    }

    public static Response<String> error(int code, String msg) {
        return Response.of(code, null, msg, null);
    }

    public static Response<String> error(String msg) {
        return Response.of(ApiCode.ERROR.getCode(), null, msg, null);
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public Response<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public Response<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Response<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Response<T> setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public Response<T> setExtra(Map<String, Object> extra) {
        this.extra = extra;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Map<String, Object> this$extra = this.getExtra();
        Map<String, Object> other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Map<String, Object> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ", traceId=" + this.getTraceId() + ", extra=" + this.getExtra() + ")";
    }
}

