/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import top.verytouch.vkit.common.base.Assert;
import top.verytouch.vkit.common.exception.BusinessException;
import top.verytouch.vkit.common.util.JsonUtils;

public class ExcelUtils {
    public static Writer writer(List<?> data) {
        return new Writer(data);
    }

    public Reader reader(InputStream inputStream) {
        return new Reader(inputStream);
    }

    public static class Writer {
        private final LinkedHashMap<String, String> alias;
        private final List<?> data;
        private final boolean writeTitle;

        private Writer(List<?> data, LinkedHashMap<String, String> alias, boolean writeTitle) {
            this.data = data;
            this.alias = alias;
            this.writeTitle = writeTitle;
        }

        private Writer(List<?> data) {
            this.data = data;
            this.alias = new LinkedHashMap();
            this.writeTitle = true;
        }

        public Writer addAlias(String name, String field) {
            this.alias.put(name, field);
            return this;
        }

        public XSSFWorkbook write() {
            int i;
            Assert.nonEmpty(this.alias, "alias\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.nonNull(this.data, "data\u4e0d\u80fd\u4e3a\u7a7a");
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            Map<Object, Object> maxLengthCol = this.writeTitle ? this.writeTitle(workbook, sheet) : new HashMap();
            Set<Map.Entry<String, String>> titleEntries = this.alias.entrySet();
            for (i = 0; i < this.data.size(); ++i) {
                XSSFRow row = sheet.createRow(i + 1);
                JsonNode json = JsonUtils.toTree(this.data.get(i));
                int j = 0;
                for (Map.Entry<String, String> titleEntry : titleEntries) {
                    String valueStr = json.get(titleEntry.getValue()).asText("");
                    maxLengthCol.merge(j, valueStr, (a, b) -> a.length() > b.length() ? a : b);
                    XSSFCell cell = row.createCell(j, 1);
                    cell.setCellValue(valueStr);
                    ++j;
                }
            }
            for (i = 0; i < this.alias.size(); ++i) {
                sheet.setColumnWidth(i, ((String)maxLengthCol.get(i) + "\u5360\u4f4d").getBytes().length * 256);
            }
            return workbook;
        }

        public void write(OutputStream outputStream) {
            XSSFWorkbook workbook = null;
            try {
                workbook = this.write();
                workbook.write(outputStream);
            }
            catch (Exception e) {
                throw new BusinessException("\u751f\u6210excel\u5931\u8d25");
            }
            finally {
                try {
                    if (workbook != null) {
                        workbook.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private Map<Integer, String> writeTitle(XSSFWorkbook workbook, XSSFSheet sheet) {
            XSSFFont whiteBold = workbook.createFont();
            whiteBold.setBold(true);
            whiteBold.setColor((short)9);
            XSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setFillForegroundColor((short)54);
            titleStyle.setFillPattern((short)1);
            titleStyle.setFont((Font)whiteBold);
            HashMap<Integer, String> maxLengthCol = new HashMap<Integer, String>();
            XSSFRow row = sheet.createRow(0);
            int colNum = 0;
            for (Map.Entry<String, String> entry : this.alias.entrySet()) {
                XSSFCell cell = row.createCell(colNum);
                maxLengthCol.put(colNum, entry.getKey());
                cell.setCellValue(entry.getKey());
                cell.setCellStyle((CellStyle)titleStyle);
                ++colNum;
            }
            return maxLengthCol;
        }
    }

    public static class Reader {
        private final XSSFWorkbook workbook;

        public Reader(InputStream inputStream) {
            try {
                this.workbook = new XSSFWorkbook(inputStream);
            }
            catch (IOException e) {
                throw new BusinessException(e);
            }
        }

        public List<List<String>> read(int sheetIndex) {
            XSSFSheet sheet = this.workbook.getSheetAt(sheetIndex);
            int lastRowNum = sheet.getLastRowNum();
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            for (int i = 0; i < lastRowNum; ++i) {
                XSSFRow row = sheet.getRow(i);
                int lastCellNum = row.getLastCellNum();
                ArrayList<String> list = new ArrayList<String>();
                for (int j = 0; j < lastCellNum; ++j) {
                    list.add(row.getCell(j).getStringCellValue());
                }
                data.add(list);
            }
            return data;
        }

        public List<Map<String, String>> readAsMap(int sheetIndex, List<String> keys) {
            return this.read(sheetIndex).stream().map(values -> {
                HashMap map = new HashMap();
                if (keys.size() != values.size()) {
                    return map;
                }
                for (int i = 0; i < keys.size(); ++i) {
                    map.put(keys.get(i), values.get(i));
                }
                return map;
            }).collect(Collectors.toList());
        }
    }
}

