/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.common.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import top.verytouch.vkit.common.base.Assert;
import top.verytouch.vkit.common.exception.BusinessException;
import top.verytouch.vkit.common.util.JsonUtils;

public class HttpUtils {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_FORM = "application/x-www-url-form-encoded";
    private String url;
    private String method = "GET";
    private Map<String, String> headers;
    private Map<String, Object> params;
    private byte[] body;
    private Charset charset = StandardCharsets.UTF_8;
    private int connectTimeout = 3000;
    private int readTimeout = 10000;
    private boolean followRedirects = false;
    private boolean useCaches = false;
    private boolean encodeParam = true;

    public HttpUtils(String url) {
        Assert.nonNull(url, "url cannot be null or empty");
        this.url = url;
    }

    public static String get(String url) {
        return new HttpUtils(url).get();
    }

    public static String get(String url, Map<String, Object> params) {
        return new HttpUtils(url).params(params).get();
    }

    public static String post(String url, Map<String, Object> params) {
        return new HttpUtils(url).params(params).post();
    }

    public static String postJson(String url, Object body) {
        return new HttpUtils(url).addHeader("Content-Type", APPLICATION_JSON).body(JsonUtils.toJson(body).getBytes(StandardCharsets.UTF_8)).post();
    }

    public static byte[] download(String url) {
        return new HttpUtils(url).caughtRequest().getBytes();
    }

    public HttpResponse caughtRequest() {
        try {
            return this.request();
        }
        catch (Exception e) {
            throw new BusinessException("Http\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request() throws Exception {
        if (this.params != null && this.params.size() > 0) {
            this.url = this.url + "?" + this.params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(this.body != null);
            connection.setUseCaches(this.useCaches);
            connection.setInstanceFollowRedirects(this.followRedirects);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setRequestMethod(this.method);
            if (this.headers != null && this.headers.size() > 0) {
                for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                    connection.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            connection.connect();
            if (this.body != null) {
                try (OutputStream out = connection.getOutputStream();){
                    IOUtils.copy((InputStream)new ByteArrayInputStream(this.body), (OutputStream)out);
                }
            }
            Assert.require(connection.getResponseCode() == 200, String.format("request failed: code=%s, message=%s", connection.getResponseCode(), connection.getResponseMessage()));
            HttpResponse httpResponse = new HttpResponse(IOUtils.toByteArray((InputStream)connection.getInputStream()), connection.getHeaderFields());
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public String get() {
        return this.method("GET").caughtRequest().getString();
    }

    public String post() {
        return this.method("POST").caughtRequest().getString();
    }

    public HttpUtils method(String method) {
        this.method = method;
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpUtils addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpUtils params(Map<String, Object> params) {
        this.params = params;
        if (this.encodeParam && this.params != null) {
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                entry.setValue(this.urlEncode(entry.getValue().toString()));
            }
        }
        return this;
    }

    public HttpUtils addParam(String key, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, this.encodeParam ? this.urlEncode(value) : value);
        return this;
    }

    public HttpUtils charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public HttpUtils encodeParam(boolean encodeParam) {
        this.encodeParam = encodeParam;
        return this;
    }

    public HttpUtils body(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpUtils readTimeout(Duration duration) {
        this.readTimeout = (int)duration.toMillis();
        return this;
    }

    public HttpUtils connectTimeout(Duration duration) {
        this.connectTimeout = (int)duration.toMillis();
        return this;
    }

    public HttpUtils useCaches(boolean useCaches) {
        this.useCaches = useCaches;
        return this;
    }

    public HttpUtils followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class HttpResponse {
        private final byte[] bytes;
        private final Map<String, String> headers;

        public HttpResponse(byte[] bytes, Map<String, List<String>> headers) {
            this.bytes = bytes;
            this.headers = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty() ? (String)((List)entry.getValue()).get(0) : ""));
        }

        public String getString() {
            return new String(this.bytes);
        }

        public <T> T toBean(Class<T> beanType) {
            return JsonUtils.fromJson(new String(this.bytes), beanType);
        }

        public <T> List<T> toList(Class<T> itemType) {
            return JsonUtils.listFromJson(new String(this.bytes), itemType);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpResponse)) {
                return false;
            }
            HttpResponse other = (HttpResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getBytes(), other.getBytes())) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getBytes());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        public String toString() {
            return "HttpUtils.HttpResponse(bytes=" + Arrays.toString(this.getBytes()) + ", headers=" + this.getHeaders() + ")";
        }
    }
}

