/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.oauth2.server.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;
import top.verytouch.vkit.samples.oauth2.server.oauth2.CachedAuthorizationCodeServices;
import top.verytouch.vkit.samples.oauth2.server.oauth2.TokenGranters;
import top.verytouch.vkit.samples.oauth2.server.oauth2.UserService;

@Configuration
@EnableAuthorizationServer
public class AuthorizationServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtAccessTokenConverter jwtAccessTokenConverter;
    @Autowired
    private TokenEnhancerChain tokenEnhancerChain;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private UserDetailsService userDetailsService;

    public void configure(AuthorizationServerSecurityConfigurer security) {
        security.allowFormAuthenticationForClients().checkTokenAccess("permitAll()").tokenKeyAccess("permitAll()");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        super.configure(clients);
        HashMap<String, String> clientRedirectUriMap = new HashMap<String, String>();
        clientRedirectUriMap.put("test1", "http://localhost:91/one/login");
        clientRedirectUriMap.put("test2", "http://localhost:92/two/login");
        InMemoryClientDetailsServiceBuilder builder = clients.inMemory();
        for (Map.Entry clientUri : clientRedirectUriMap.entrySet()) {
            builder.withClient((String)clientUri.getKey()).secret("$2a$10$piCRbkfQUTAHjsbgXcoFrOSkuHTb7K8lGrTclGZvgjr.LK1ZWmUJa").authorizedGrantTypes(new String[]{"password", "refresh_token", "authorization_code", "client_credentials", "implicit", "sms_code"}).scopes(new String[]{"all"}).autoApprove(false).redirectUris(new String[]{"http://localhost:90/index.html", (String)clientUri.getValue()}).accessTokenValiditySeconds(1800).refreshTokenValiditySeconds(604800);
        }
    }

    public void configure(AuthorizationServerEndpointsConfigurer configurer) {
        configurer.tokenStore(this.tokenStore).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter).tokenEnhancer((TokenEnhancer)this.tokenEnhancerChain).authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService).authorizationCodeServices((AuthorizationCodeServices)new CachedAuthorizationCodeServices()).tokenGranter(TokenGranters.defaultTokenGranters(configurer, this.authenticationManager, (UserService)this.userDetailsService));
    }

    @Controller
    @SessionAttributes(value={"authorizationRequest"})
    public static class PageController {
        @RequestMapping(value={"/oauth/confirm_access"})
        public ModelAndView authPage(Map<String, Object> model, ModelAndView mv) {
            AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
            mv.addObject("clientId", (Object)authorizationRequest.getClientId());
            mv.addObject("scopes", (Object)authorizationRequest.getScope());
            mv.setViewName("authorize");
            return mv;
        }
    }
}

