/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.oauth2.server.oauth2;

import java.time.Duration;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.code.RandomValueAuthorizationCodeServices;

public class CachedAuthorizationCodeServices
extends RandomValueAuthorizationCodeServices {
    private static final String CODE_KEY = "auth:code:%s";
    private static final Duration CODE_TIMEOUT = Duration.ofMinutes(3L);
    private final Cache<String, OAuth2Authentication> cache;

    public CachedAuthorizationCodeServices() {
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build();
        cacheManager.init();
        this.cache = cacheManager.createCache("authorizationCode", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, OAuth2Authentication.class, (Builder)ResourcePoolsBuilder.heap((long)1L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)CODE_TIMEOUT)));
    }

    protected void store(String code, OAuth2Authentication authentication) {
        this.cache.put((Object)String.format(CODE_KEY, code), (Object)authentication);
    }

    protected OAuth2Authentication remove(String code) {
        OAuth2Authentication authentication = (OAuth2Authentication)this.cache.get((Object)String.format(CODE_KEY, code));
        if (authentication != null) {
            this.cache.remove((Object)String.format(CODE_KEY, code));
        }
        return authentication;
    }
}

