/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.oauth2.server.oauth2;

import java.util.LinkedHashMap;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import top.verytouch.vkit.samples.oauth2.server.oauth2.UserService;

public class SmsCodeTokenGranter
extends AbstractTokenGranter {
    private final UserService userService;

    public SmsCodeTokenGranter(UserService userService, AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetails, OAuth2RequestFactory requestFactory) {
        super(tokenServices, clientDetails, requestFactory, "sms_code");
        this.userService = userService;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        LinkedHashMap parameters = new LinkedHashMap(tokenRequest.getRequestParameters());
        String phone = (String)parameters.get("phone");
        String code = (String)parameters.get("code");
        if (!"1234".equals(code)) {
            throw new InvalidGrantException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        UserDetails userDetails = this.userService.loadUserByPhone(phone);
        if (userDetails == null) {
            throw new InvalidGrantException("\u624b\u673a\u53f7\u4e0d\u6b63\u786e");
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), null, userDetails.getAuthorities());
        authentication.setDetails(parameters);
        OAuth2Request oAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(oAuth2Request, (Authentication)authentication);
    }
}

