/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.rabbitmq.common;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitConnection;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitExchange;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueue;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueueBind;

public final class RabbitChannel {
    private RabbitChannel() {
    }

    public static Channel newChannel(RabbitQueue queue) {
        return new Builder(RabbitConnection.getConnection()).queue(queue).build();
    }

    public static Channel newChannel(RabbitQueueBind bind) {
        return new Builder(RabbitConnection.getConnection()).bind(bind).build();
    }

    public static final class Builder {
        private final Connection connection;
        private RabbitQueue queue;
        private RabbitExchange exchange;
        private RabbitQueueBind bind;

        public Builder(Connection connection) {
            this.connection = connection;
        }

        public Builder queue(RabbitQueue queue) {
            this.queue = queue;
            return this;
        }

        public Builder exchange(RabbitExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        public Builder bind(RabbitQueueBind bind) {
            this.bind = bind;
            return this;
        }

        public Channel build() {
            if (this.bind != null) {
                this.queue = this.bind.getQueue();
                this.exchange = this.bind.getExchange();
            }
            if (this.queue == null) {
                throw new RuntimeException("\u83b7\u53d6rabbit-channel\u5931\u8d25\uff0cqueue\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                Channel channel = this.connection.createChannel();
                channel.queueDeclare(this.queue.name(), true, false, false, null);
                if (this.exchange != null) {
                    channel.exchangeDeclare(this.exchange.name(), this.exchange.getType());
                }
                if (this.bind != null) {
                    channel.queueBind(this.queue.name(), this.bind.getExchange().name(), this.bind.getRoutingKey());
                }
                return channel;
            }
            catch (IOException e) {
                throw new RuntimeException("\u83b7\u53d6rabbit-channel\u5931\u8d25", e);
            }
        }
    }
}

