/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitChannel;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueue;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueueBind;
import top.verytouch.vkit.samples.rabbitmq.consumer.AckConsumer;

public class RabbitConsumer {
    public static void consume(RabbitQueue queue) {
        try {
            Channel channel = RabbitChannel.newChannel(queue);
            channel.basicConsume(queue.name(), true, (Consumer)new AckConsumer((Object)queue, channel, true));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d88\u8d39\u5931\u8d25\uff0cqueue=" + (Object)((Object)queue));
        }
        RabbitConsumer.waitHere();
    }

    public static void consumeAllBind(boolean autoAck) {
        try {
            for (RabbitQueueBind value : RabbitQueueBind.values()) {
                Channel channel = RabbitChannel.newChannel(value);
                channel.basicConsume(value.getQueue().name(), autoAck, (Consumer)new AckConsumer((Object)value, channel, autoAck));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u6d88\u8d39\u5931\u8d25");
        }
        RabbitConsumer.waitHere();
    }

    private static void waitHere() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

