/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.samples.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitChannel;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueue;
import top.verytouch.vkit.samples.rabbitmq.common.RabbitQueueBind;

public class RabbitProducer {
    public static void send(RabbitQueue queue, String message) {
        try (Channel channel = RabbitChannel.newChannel(queue);){
            channel.basicPublish("", queue.name(), null, message.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cqueue=%s, message=%s", new Object[]{queue, message}));
        }
    }

    public static void send(RabbitQueueBind bind, String message) {
        try (Channel channel = RabbitChannel.newChannel(bind);){
            channel.basicPublish(bind.getExchange().name(), bind.getRoutingKey(), null, message.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cbind=%s, message=%s", new Object[]{bind, message}));
        }
    }

    public static void sendConfirm(RabbitQueueBind bind, String message) {
        try (Channel channel = RabbitChannel.newChannel(bind);){
            channel.confirmSelect();
            channel.basicPublish(bind.getExchange().name(), bind.getQueue().name(), null, message.getBytes());
            if (!channel.waitForConfirms()) {
                System.out.println("\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cbind=%s, message=%s", new Object[]{bind, message}));
        }
    }

    public static void sendTx(RabbitQueueBind bind, String message) {
        Channel channel = null;
        try {
            channel = RabbitChannel.newChannel(bind);
            channel.txSelect();
            channel.basicPublish(bind.getExchange().name(), bind.getQueue().name(), MessageProperties.PERSISTENT_TEXT_PLAIN, message.getBytes());
            channel.txCommit();
        }
        catch (Exception e) {
            if (channel != null) {
                try {
                    channel.txRollback();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            throw new RuntimeException(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cbind=%s, message=%s", new Object[]{bind, message}));
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

