/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import top.verytouch.vkit.alipay.AlipayProperties;

public class AlipayService {
    private final AlipayProperties properties;
    private final AlipayClient alipayClient;

    public AlipayService(AlipayProperties properties) {
        this.properties = properties;
        this.alipayClient = new DefaultAlipayClient(properties.getGatewayUrl(), properties.getAppId(), properties.getPrivateKey(), properties.getFormat(), properties.getCharset(), properties.getAlipayPublicKey(), properties.getSignType());
    }

    public String getAuthorizeUrl(String state) {
        return String.format("%s?app_id=%s&redirect_uri=%s&scope=auth_user&state=%s", this.properties.getAuthorizeUrl(), this.properties.getAppId(), this.properties.getRedirectUri(), state);
    }

    public AlipaySystemOauthTokenResponse getToken(String code) throws AlipayApiException {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(code);
        return (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
    }

    public AlipaySystemOauthTokenResponse refreshToken(String refreshToken) throws AlipayApiException {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("refresh_token");
        request.setRefreshToken(refreshToken);
        return (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
    }

    public AlipayUserInfoShareResponse getUserInfo(String token) throws AlipayApiException {
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        return (AlipayUserInfoShareResponse)this.alipayClient.execute((AlipayRequest)request, token);
    }
}

