/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.ocr.ali;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.ocr.ali.AliOcrService;

public class AliOcrHelper {
    private static final Logger log = LoggerFactory.getLogger(AliOcrHelper.class);

    public static void generalOcrBatch(AliOcrService service, String imgDir, OutputStream out) throws Exception {
        Collection files = FileUtils.listFiles((File)new File(imgDir + "\\kd"), (String[])new String[]{"jpg", "png"}, (boolean)false);
        int i = 1;
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            for (File file : files) {
                log.info("\u6b63\u5728\u5904\u7406\u7b2c" + i + "\u5f20");
                ByteArrayOutputStream imgStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)imgStream);
                String img = Base64.getEncoder().encodeToString(imgStream.toByteArray());
                String text = AliOcrHelper.getGeneralWords(service.general(img), "\n");
                writer.write("\n" + i + ".======================================\n" + text);
                ++i;
            }
            writer.flush();
        }
    }

    public static String getGeneralWords(String json, String delimiter) {
        return String.join((CharSequence)delimiter, (Iterable)JsonPath.parse((String)json).read("$.ret[*].word", List.class, new Predicate[0]));
    }
}

