/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.oss.ali;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.common.exception.BusinessException;
import top.verytouch.vkit.oss.OssProperties;
import top.verytouch.vkit.oss.OssService;

public class AliOssService
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(AliOssService.class);
    private final OssProperties properties;
    private final OSS oss;

    public AliOssService(OssProperties properties) {
        this.properties = properties;
        this.oss = new OSSClientBuilder().build(properties.getEndpoint(), properties.getAccessId(), properties.getAccessKey());
    }

    @Override
    public String upload(String bucket, String object, File file) {
        this.checkBucket(bucket);
        try {
            this.oss.putObject(bucket, object, (InputStream)new FileInputStream(file));
            return this.getPreviewUrl(bucket, object);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s\uff0cfile=%s", bucket, object, file.getName()), (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public String upload(String bucket, String object, InputStream stream, long length, String contentType) {
        this.checkBucket(bucket);
        try {
            this.oss.putObject(bucket, object, stream);
            return this.getPreviewUrl(bucket, object);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public String getUploadUrl(String bucket, String object) {
        String signature;
        String policy;
        this.checkBucket(bucket);
        String host = String.format("https://%s.%s", bucket, this.properties.getEndpoint());
        String dir = "";
        Date expire = new Date(System.currentTimeMillis() + (long)this.properties.getUploadUrlExpireMinutes() * 1000L);
        PolicyConditions conditions = new PolicyConditions();
        conditions.addConditionItem("content-length-range", 0L, 0x140000000L);
        conditions.addConditionItem(MatchMode.StartWith, "key", dir);
        try {
            policy = this.oss.generatePostPolicy(expire, conditions);
            signature = this.oss.calculatePostSignature(policy);
        }
        catch (Exception e2) {
            log.error(String.format("\u751f\u6210\u4e0a\u4f20\u94fe\u63a5\u5931\u8d25\uff0cbucket=%s", bucket), (Throwable)e2);
            throw new BusinessException("\u751f\u6210\u4e0a\u4f20\u94fe\u63a5\u5931\u8d25");
        }
        policy = BinaryUtil.toBase64String((byte[])policy.getBytes(StandardCharsets.UTF_8));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("accessid", this.properties.getAccessId());
        params.put("policy", policy);
        params.put("signature", signature);
        params.put("dir", dir);
        params.put("expire", String.valueOf(expire.getTime() / 1000L));
        return host + "?" + params.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }

    @Override
    public String getPreviewUrl(String bucket, String object) {
        return String.format("https://%s.%s/%s", bucket, this.properties.getEndpoint(), object);
    }

    @Override
    public InputStream download(String bucket, String object) {
        this.checkBucket(bucket);
        try {
            return this.oss.getObject(bucket, object).getObjectContent();
        }
        catch (Exception e) {
            log.error(String.format("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public void delete(String bucket, String object) {
        this.checkBucket(bucket);
        try {
            this.oss.deleteObject(bucket, object);
        }
        catch (Exception e) {
            log.error(String.format("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public void checkBucket(String bucket) {
        if (this.properties.isValidateBucket() && !this.properties.getValidBuckets().contains(bucket)) {
            throw new BusinessException("bucket " + bucket + " \u4e0d\u5408\u6cd5");
        }
    }
}

