/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rabc;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import top.verytouch.vkit.rabc.RbacProperties;
import top.verytouch.vkit.rabc.config.AuthorizationSererConfig;
import top.verytouch.vkit.rabc.config.ResourceServerConfig;
import top.verytouch.vkit.rabc.config.WebSecurityConfig;
import top.verytouch.vkit.rabc.oauth2.AesPasswordEncoder;
import top.verytouch.vkit.rabc.oauth2.InMemoryAuthorizationCodeService;
import top.verytouch.vkit.rabc.oauth2.JwtUserDetailsTokenEnhancer;
import top.verytouch.vkit.rabc.oauth2.ParameterPasswordEncoder;
import top.verytouch.vkit.rabc.web.RestControllerAdvice;

@Configuration
@EnableConfigurationProperties(value={RbacProperties.class})
@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class, AuthorizationServerConfigurerAdapter.class, ResourceServerConfigurerAdapter.class})
@ConditionalOnProperty(prefix="vkit.rbac", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={WebSecurityConfig.class, AuthorizationSererConfig.class, ResourceServerConfig.class})
public class RbacAutoConfiguration {
    @Autowired
    private RbacProperties rbacProperties;

    @Bean
    @ConditionalOnMissingBean(value={ParameterPasswordEncoder.class})
    public ParameterPasswordEncoder parameterPasswordEncoder() {
        return new AesPasswordEncoder(this.rbacProperties.getParameterAesKey(), null);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizationCodeServices.class})
    public AuthorizationCodeServices authorizationCodeServices() {
        return new InMemoryAuthorizationCodeService(Duration.ofSeconds(3L));
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtUserDetailsTokenEnhancer.class})
    public JwtUserDetailsTokenEnhancer jwtUserDetailsTokenEnhancer() {
        return userDetails -> null;
    }

    @Bean
    @ConditionalOnProperty(prefix="vkit.rbac", name={"exceptionHandlerEnabled"}, havingValue="true", matchIfMissing=true)
    public RestControllerAdvice restControllerAdvice() {
        return new RestControllerAdvice();
    }
}

