/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rabc.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import top.verytouch.vkit.common.base.ApiCode;
import top.verytouch.vkit.common.base.Response;
import top.verytouch.vkit.common.util.JsonUtils;
import top.verytouch.vkit.common.util.StringUtils;
import top.verytouch.vkit.rabc.oauth2.OauthException;

public class OauthExceptionSerializer
extends StdSerializer<OauthException> {
    private static final Logger log = LoggerFactory.getLogger(OauthExceptionSerializer.class);

    protected OauthExceptionSerializer() {
        super(OauthException.class);
    }

    public void serialize(OauthException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        log.error("\u8ba4\u8bc1\u5931\u8d25", (Throwable)((Object)value));
        gen.writeObject((Object)Response.error((String)StringUtils.substring((String)value.getMessage(), (int)0, (int)50)));
    }

    public static void exceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        int status;
        ApiCode error;
        log.error(request.getRequestURI(), (Throwable)e);
        if (e instanceof AuthenticationException) {
            error = ApiCode.SYS_UNAUTHENTICATED;
            status = 401;
        } else if (e instanceof AccessDeniedException) {
            error = ApiCode.SYS_FORBIDDEN;
            status = 403;
        } else {
            status = 500;
            error = ApiCode.ERROR;
        }
        response.setStatus(status);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.write(JsonUtils.toJson((Object)Response.error((int)error.getCode(), (String)error.getDesc())));
        writer.flush();
        writer.close();
    }
}

