/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rabc.uti;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import top.verytouch.vkit.common.util.JsonUtils;

public class Oauth2Utils {
    public static String getUsername() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    public static OAuth2AuthenticationDetails getDetails() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (OAuth2AuthenticationDetails)authentication.getDetails();
    }

    public static List<String> getAuthorities() {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(auth -> auth.getAuthority()).collect(Collectors.toList());
    }

    public static String getAccessToken() {
        return Oauth2Utils.getDetails().getTokenValue();
    }

    public static Map<String, Object> getJwtUserInfo() {
        String claims = JwtHelper.decode((String)Oauth2Utils.getDetails().getTokenValue()).getClaims();
        return (Map)JsonUtils.fromJson((String)claims, HashMap.class);
    }
}

